<?php
/**
 * Plugin Name:       Activity Monitor Pro
 * Plugin URI:        https://lovabuild.com/wordpress-plugins/activity-monitor-pro
 * Description:       Comprehensive activity monitoring, undo system, and AI-powered anomaly detection for WordPress... Free Version 1.0.0
 * Version:           1.0.0
 * Requires PHP:      7.4
 * Author:            Wole Akinloye
 * Author URI:        https://x.com/wolexfeelcool
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

/**
 * Currently plugin version.
 */
define('ACTIVITY_MONITOR_PRO_VERSION', '1.0.0');

/**
 * Plugin Root File Path
 */
define('ACTIVITY_MONITOR_PRO_PATH', plugin_dir_path(__FILE__));

/**
 * Plugin Root URL
 */
define('ACTIVITY_MONITOR_PRO_URL', plugin_dir_url(__FILE__));

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-activator.php
 */
function activity_monitor_pro_activate()
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-activator.php';
    Activity_Monitor_Pro_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-deactivator.php
 */
function activity_monitor_pro_deactivate()
{
    require_once plugin_dir_path(__FILE__) . 'includes/class-deactivator.php';
    Activity_Monitor_Pro_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activity_monitor_pro_activate');
register_deactivation_hook(__FILE__, 'activity_monitor_pro_deactivate');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path(__FILE__) . 'includes/class-core.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 */
function activity_monitor_pro_run()
{

    $plugin = new Activity_Monitor_Pro();
    $plugin->run();

}
activity_monitor_pro_run();
