<?php

/**
 * Provide a public-facing view for the plugin
 *
 * This file is used to markup the public-facing aspects of the plugin.
 *
 * @link       https://acewebx.com
 * @since      1.0.0
 *
 * @package    Ace_Tic_Tac_Toe
 * @subpackage Ace_Tic_Tac_Toe/public/partials
 */

if ( ! defined( 'WPINC' ) ) {
	die;
}

$options = get_option('tic_tac_toe_options', []);

$title_check_box = $options['title_enable'] ?? '';
if (!empty($title_check_box)) {
    $game_title = !empty($options['game_title']) ? esc_html($options['game_title']) : 'Tic Tac Toe';
}

$default_players = $options['default_players'] ?? '2';
$bg_color        = $options['bg_color'] ?? 'linear-gradient(135deg, #667eea, #764ba2)';
$button_color    = $options['button_color'] ?? '#00aaff';
$play_type       = $options['play_type'] ?? 'single';
?>
<div class="tic_tac_outer" style="background: <?php echo esc_attr($bg_color); ?>;">
    <?php if (!empty($game_title)) : ?>
        <h1 class="game-title"><?php echo esc_html($game_title); ?></h1>
    <?php endif; ?>

    <div class="container tic_tac_container" style="background: <?php echo esc_attr($bg_color); ?>;">
        <div class="tic_tac_column_1">
            <div class="tic_tac_game_bord" style="background: <?php echo esc_attr($bg_color); ?>;">
                <h1 class="play-type-title">
                    <?php echo esc_html($play_type === 'single' ? 'Play with Computer' : 'Play with Friends'); ?>
                </h1>
                <div class="tic-tac-toe-board" style="position:relative;">
                    <div id="win-line" style="background-color: <?php echo esc_attr($bg_color); ?>;"></div>
                    <div class="board">
                        <?php for ($i = 0; $i < 9; $i++) : ?>
                            <div class="cell"></div>
                        <?php endfor; ?>
                    </div>
                </div>
                <div id="message_container">
                    <p id="message"></p>
                </div>
                <button id="new_game" class="hide" style="background-color: <?php echo esc_attr($button_color); ?>;">New Game</button>
                <button id="button_reset" style="background-color: <?php echo esc_attr($button_color); ?>;">Reset</button>
            </div>
        </div>

        <div class="tic_tac_column_2">
            <div class="scoreboard_outer">
                <div class="scoreboard">
                    <h2><strong>Score:</strong></h2>
                    <p><?php echo esc_html($options['first_player'] ?? 'X'); ?>:<span id="score_x">0</span></p>
                    <p>
                        <?php
                        echo esc_html(
                            $play_type === 'single'
                                ? 'Computer'
                                : ($options['second_player'] ?? 'O')
                        );
                        ?>:
                        <span id="score_y">0</span>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
