(function( $ ) {
	'use strict';

	/**
	 * All of the code for your public-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */
    let First_player_name = '';
    let Second_player_name = '';

    let firstPlayerDisplay = '';
    let secondPlayerDisplay = '';
    let uploadsBaseUrl = ticTacToeData.uploads_url;
    const adminData = ticTacToeData.tic_tac_admin_data;
    // First Player Name / Avatar
    if (adminData.first_player_avtar) {
        firstPlayerDisplay = `<img src="${uploadsBaseUrl}/${adminData.first_player_avtar}" alt="${adminData.first_player || 'X'}" class="player_avtarimage">`;
        First_player_name = adminData.first_player_avtar;
    } else {
        firstPlayerDisplay = adminData.first_player || 'X';
        First_player_name = firstPlayerDisplay;
    }
    if (adminData.second_player_avtar) {
        secondPlayerDisplay = `<img src="${uploadsBaseUrl}/${adminData.second_player_avtar}" alt="${adminData.second_player || 'O'}" class="player_avtarimage">`;
        Second_player_name = adminData.second_player_avtar;
    } else {
        secondPlayerDisplay = adminData.second_player || 'O';
        Second_player_name = secondPlayerDisplay;
    }
    let isTwoPlayerMode = adminData.play_type !== 'single';
    const cells = document.querySelectorAll(".cell");
    const messageContainer = document.getElementById("message_container");
    const resetButton = document.getElementById("button_reset");
    const newGameButton = document.getElementById("new_game");
    const scoreX = document.getElementById("score_x");
    const scoreY = document.getElementById("score_y");
    let currentPlayer = firstPlayerDisplay;
    let firstPlayerWins = 0;
    let secondPlayerWins = 0;
    const winPatterns = [[0,1,2],[0,3,6],[0,4,8],[1,4,7],[2,5,8],[2,4,6],[3,4,5],[6,7,8]];
    const updateMessage = (message, isEnd = false) => {
        messageContainer.innerHTML = message;
        messageContainer.style.display = isEnd ? 'block' : 'none';
    };
    const handleClick = (e) => {
        if (e.target.innerHTML) return;
        if (isTwoPlayerMode) {
            e.target.innerHTML = currentPlayer;
            e.target.style.pointerEvents = 'none';
            if (isWin()) return;
            if (isDraw()) return endGame("It's a draw!");
            currentPlayer = (currentPlayer === firstPlayerDisplay) ? secondPlayerDisplay : firstPlayerDisplay;
        } else {
            if (currentPlayer !== firstPlayerDisplay) return;
            e.target.innerHTML = currentPlayer;
            e.target.style.pointerEvents = 'none';
            if (isWin()) return;
            if (isDraw()) return endGame("It's a draw!");
            currentPlayer = secondPlayerDisplay;
            setTimeout(systemMove, 500);
        }
    };
    const isWin = () => {
        for (const [a, b, c] of winPatterns) {
            if (
                cells[a].innerHTML === currentPlayer &&
                cells[b].innerHTML === currentPlayer &&
                cells[c].innerHTML === currentPlayer
            ) {
                cells[a].classList.add("win");
                cells[b].classList.add("win");
                cells[c].classList.add("win");
                drawWinLine(a, c);
                endGame(`${currentPlayer} wins!`);
                return true;
            }
        }
        return false;
    };
    const isDraw = () => [...cells].every(cell => cell.innerHTML);
    const endGame = (message) => {
        updateMessage(message, true);
        cells.forEach(cell => cell.style.pointerEvents = 'none');
        newGameButton.classList.remove('hide');
        if (message.includes("wins")) {
            if (currentPlayer === firstPlayerDisplay) {
                firstPlayerWins++;
                scoreX.textContent = firstPlayerWins;
            } else {
                secondPlayerWins++;
                scoreY.textContent = secondPlayerWins;
            }
            if (firstPlayerWins === 3) {
                updateMessage(`${firstPlayerDisplay} wins the round!`, true);
                storeWinner(firstPlayerDisplay);
                [resetButton, newGameButton].forEach(btn => btn.addEventListener('click', function(e){
                    e.preventDefault(); 
                    location.reload();
                }));
            } else if (secondPlayerWins === 3) {
                updateMessage(`${secondPlayerDisplay} wins the round!`, true);
                let winner = isTwoPlayerMode ? secondPlayerDisplay : 'Computer';
                storeWinner(winner);
                [resetButton, newGameButton].forEach(btn => btn.addEventListener('click', function(e){
                    e.preventDefault(); 
                    location.reload();
                }));
            }
        }
    };
    const storeWinner = (winnerName) => {
        $.ajax({
            url: ajaxUrl,
            method: 'POST',
            data: {
                action: 'store_ttt_winner',
                winner: winnerName
            },
            success: function(response) {
                console.log('Winner stored successfully:', response);
            },
            error: function(xhr, status, error) {
                console.error('Error storing winner:', error);
            }
        });
    };

    const resetGame = () => {
        updateMessage('', false);
        cells.forEach(cell => {
            cell.innerHTML = '';
            cell.style.pointerEvents = 'auto';
            cell.classList.remove("win");
        });
        newGameButton.classList.add('hide');
        const line = document.getElementById('win-line');
        if (line) line.style.width = '0';
        currentPlayer = firstPlayerDisplay;
    };

    const drawWinLine = (a, c) => {
        const cellA = cells[a].getBoundingClientRect();
        const cellC = cells[c].getBoundingClientRect();
        const board = document.querySelector('.tic-tac-toe-board').getBoundingClientRect();
        const line = document.getElementById('win-line');
        const x1 = cellA.left + cellA.width / 2 - board.left;
        const y1 = cellA.top + cellA.height / 2 - board.top;
        const x2 = cellC.left + cellC.width / 2 - board.left;
        const y2 = cellC.top + cellC.height / 2 - board.top;
        const length = Math.hypot(x2 - x1, y2 - y1);
        const angle = Math.atan2(y2 - y1, x2 - x1) * 180 / Math.PI;
        line.style.width = `${length}px`;
        line.style.transform = `translate(${x1}px, ${y1}px) rotate(${angle}deg)`;
        line.style.display = 'block';
    };

    const systemMove = () => {
        let bestScore = -Infinity;
        let move;
        cells.forEach((cell, index) => {
            if (!cell.innerHTML) {
                cell.innerHTML = secondPlayerDisplay;
                let score = minimax(cells, 0, false);
                cell.innerHTML = '';
                if (score > bestScore) {
                    bestScore = score;
                    move = index;
                }
            }
        });

        cells[move].innerHTML = secondPlayerDisplay;
        cells[move].style.pointerEvents = 'none';
        if (isWin()) return;
        if (isDraw()) return endGame("It's a draw!");
        currentPlayer = firstPlayerDisplay;
    };

    const minimax = (boardCells, depth, isMaximizing) => {
        let result = checkWinner(boardCells);
        if (result !== null) {
            const scores = {};
            scores[secondPlayerDisplay] = 1;
            scores[firstPlayerDisplay] = -1;
            scores['tie'] = 0;
            return scores[result];
        }

        if (isMaximizing) {
            let bestScore = -Infinity;
            boardCells.forEach((cell) => {
                if (!cell.innerHTML) {
                    cell.innerHTML = secondPlayerDisplay;
                    let score = minimax(boardCells, depth + 1, false);
                    cell.innerHTML = '';
                    bestScore = Math.max(score, bestScore);
                }
            });
            return bestScore;
        } else {
            let bestScore = Infinity;
            boardCells.forEach((cell) => {
                if (!cell.innerHTML) {
                    cell.innerHTML = firstPlayerDisplay;
                    let score = minimax(boardCells, depth + 1, true);
                    cell.innerHTML = '';
                    bestScore = Math.min(score, bestScore);
                }
            });
            return bestScore;
        }
    };

    const checkWinner = (boardCells) => {
        for (const [a, b, c] of winPatterns) {
            const valA = boardCells[a].innerHTML;
            if (valA && valA === boardCells[b].innerHTML && valA === boardCells[c].innerHTML) {
                return valA;
            }
        }
        if ([...boardCells].every(cell => cell.innerHTML)) return "tie";
        return null;
    };

    cells.forEach(cell => cell.addEventListener('click', handleClick));
    [resetButton, newGameButton].forEach(btn => btn.addEventListener('click', resetGame));


})( jQuery );
