<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://acewebx.com
 * @since      1.0.0
 *
 * @package    Ace_Tic_Tac_Toe
 * @subpackage Ace_Tic_Tac_Toe/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Ace_Tic_Tac_Toe
 * @subpackage Ace_Tic_Tac_Toe/public
 * @author     AceWebx Team <developer@acewebx.com>
 */
if ( ! defined( 'WPINC' ) ) {
	die;
}
class Ace_Tic_Tac_Toe_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Ace_Tic_Tac_Toe_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Ace_Tic_Tac_Toe_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/ace-tic-tac-toe-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Ace_Tic_Tac_Toe_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Ace_Tic_Tac_Toe_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/ace-tic-tac-toe-public.js', array( 'jquery' ), $this->version, true );
		$options = get_option( 'tic_tac_toe_options', array() );

		wp_localize_script(
			$this->plugin_name,
			'ticTacToeData',
			array(
				'tic_tac_admin_data' => $options,
				'ajax_url'           => admin_url( 'admin-ajax.php' ),
				'uploads_url'        => wp_upload_dir()['url'],
			)
		);

	}
public function tic_tac_toe_shortcode() {
		ob_start();
		require plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/ace-tic-tac-toe-public-display.php';
		return ob_get_clean(); 
	}

	/**
	 * Handle AJAX request to store the game winner.
	 */
	public function store_ttt_winner() {
		global $wpdb;

		if (
			! isset( $_POST['ttt_nonce_field'] ) ||
			! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['ttt_nonce_field'] ) ), 'ttt_save_winner_action' )
		) {
			wp_send_json_error( 'Security check failed' );
			wp_die();
		}

		$table_name = $wpdb->prefix . 'tic_tac_toe_game_data';

		$winner = isset( $_POST['winner'] ) ? sanitize_text_field( wp_unslash( $_POST['winner'] ) ) : '';

		$first_player  = 'Player 1';
		$second_player = 'Player 2';
		$game_status   = 'completed';

		$inserted = $wpdb->insert(
			$table_name,
			array(
				'first_player_name'  => $first_player,
				'second_player_name' => $second_player,
				'game_status'        => $game_status,
				'winner_name'        => $winner,
			),
			array( '%s', '%s', '%s', '%s' )
		);

		if ( $inserted ) {
			wp_send_json_success( 'Winner stored' );
		} else {
			wp_send_json_error( 'Failed to store winner' );
		}
	}
}
