<?php
/**
 * Fired during plugin deactivation
 *
 * @link       https://acewebx.com
 * @since      1.0.0
 *
 * @package    Ace_Tic_Tac_Toe
 * @subpackage Ace_Tic_Tac_Toe/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Ace_Tic_Tac_Toe
 * @subpackage Ace_Tic_Tac_Toe/includes
 * @author     AceWebx Team <developer@acewebx.com>
 */
if ( ! defined( 'WPINC' ) ) {
	die;
}
class Ace_Tic_Tac_Toe_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate()
	{
		global $wpdb;
		$table_name = $wpdb->prefix . 'tic_tac_toe_game_data';
		$sanitized_table_name = esc_sql($table_name);
		// phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
		$wpdb->query("DROP TABLE IF EXISTS `$sanitized_table_name`");
	}
}
