<?php
/**
 * Fired during plugin activation
 *
 * @link       https://acewebx.com
 * @since      1.0.0
 *
 * @package    Ace_Tic_Tac_Toe
 * @subpackage Ace_Tic_Tac_Toe/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Ace_Tic_Tac_Toe
 * @subpackage Ace_Tic_Tac_Toe/includes
 * @author     AceWebx Team <developer@acewebx.com>
 */
if ( ! defined( 'WPINC' ) ) {
	die;
}
class Ace_Tic_Tac_Toe_Activator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function activate() {
		global $wpdb;
		$table_name = $wpdb->prefix . 'tic_tac_toe_game_data';
		$charset_collate = $wpdb->get_charset_collate();
		$sql = "CREATE TABLE $table_name (
			id mediumint(9) NOT NULL AUTO_INCREMENT,
			first_player_name varchar(100) NOT NULL,
			second_player_name varchar(100) NOT NULL,
			game_status text NOT NULL,
			winner_name varchar(100),
			win_time datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
			PRIMARY KEY (id)
		) $charset_collate;";
	
		require_once ABSPATH . 'wp-admin/includes/upgrade.php';
	
		dbDelta($sql);
	}

}
