(function($) {
    'use strict';
    $(document).ready(function() {
        // Handle copying the shortcode to clipboard
        $('#copy_short_code').on('click', function() {
            const shortcodeText = $('#tic-tac-shortcode').text();
            const button = $(this);

            // Attempt to copy to clipboard (modern method)
            if (navigator.clipboard) {
                navigator.clipboard.writeText(shortcodeText).then(() => {
                    // Success - update button style
                    button.text('Copied!')
                        .css({
                            'background-color': '#46b450',
                            'border-color': '#46b450',
                            'color': '#fff'
                        });
                    setTimeout(() => {
                        button.text('Copy')
                            .css({
                                'background-color': '',
                                'border-color': '',
                                'color': ''
                            });
                    }, 2000);
                }).catch(() => {
                    // Fallback if clipboard API fails
                    alert('Failed to copy to clipboard.');
                });
            } else {
                // Fallback for older browsers (using textarea)
                const temp = document.createElement('textarea');
                temp.value = shortcodeText;
                document.body.appendChild(temp);
                temp.select();
                document.execCommand('copy');
                document.body.removeChild(temp);

                button.text('Copied!')
                    .css({
                        'background-color': '#46b450',
                        'border-color': '#46b450',
                        'color': '#fff'
                    });

                // Reset button text and style after 2 seconds
                setTimeout(() => {
                    button.text('Copy')
                        .css({
                            'background-color': '',
                            'border-color': '',
                            'color': ''
                        });
                }, 2000);
            }
        });

        // Handle avatar deletion
        $('.ttt-delete-avatar-btn').on('click', function(e) {
            e.preventDefault();

            if (!confirm('Are you sure you want to delete this avatar image?')) {
                return;
            }

            const button = $(this);
            const playerKey = button.val();

            // Perform the AJAX request to delete the avatar
            $.ajax({
                url: ticTacToeData.ajax_url,
                type: 'POST',
                data: {
                    action: 'delete_tic_tac_toe_avatar',
                    player_key: playerKey,
                    security: ticTacToeData.nonce
                },
                success: function(response) {
                    if (response.success) {
                        alert('Avatar deleted successfully.');
                        button.closest('.ttt-avatar-preview').remove();
                    } else {
                        alert(response.data.message);
                    }
                },
                error: function() {
                    alert('AJAX error: Unable to delete avatar.');
                }
            });
        });

    });
})(jQuery);


