<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://acewebx.com
 * @since      1.0.0
 *
 * @package    Ace_Tic_Tac_Toe
 * @subpackage Ace_Tic_Tac_Toe/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Ace_Tic_Tac_Toe
 * @subpackage Ace_Tic_Tac_Toe/admin
 * @author     AceWebx Team <developer@acewebx.com>
 */
if ( ! defined( 'WPINC' ) ) {
	die;
}
class Ace_Tic_Tac_Toe_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Ace_Tic_Tac_Toe_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Ace_Tic_Tac_Toe_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/ace-tic-tac-toe-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Ace_Tic_Tac_Toe_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Ace_Tic_Tac_Toe_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/ace-tic-tac-toe-admin.js', array( 'jquery' ), $this->version, true );
		wp_localize_script($this->plugin_name, 'ticTacToeData', ['ajax_url' => admin_url('admin-ajax.php')]);
		wp_localize_script($this->plugin_name,'ticTacToeData',array('ajax_url' => admin_url('admin-ajax.php'), 'nonce'    => wp_create_nonce('delete_avatar_nonce'),));

	}
   public function tic_tac_toe_add_settings_page()
    {
        add_menu_page('Tic Tac Toe Settings', 'Ace Tic Tac Toe', 'manage_options', 'ace-tic-tac-toe-settings', array($this, 'tic_tac_toe_settings_page'), 'dashicons-grid-view', 30);
    }
    public function tic_tac_toe_settings_page()
    {
?>
        <div class="wrap">
            <div class="Tic-Tac-Setting-title-bar">
                <div class="Tic-Tac-Setting-title-content">
                    <div class="Tic-Tac-Setting-title-menu" id="Ace-Setting-menu1"><span class="dashicons dashicons-grid-view"></span>
                        <h1 class="Tic-Tac-Setting-title"><?php echo esc_html('Ace Tic Tac Toe'); ?></h1>
                    </div>
                    <a class="Tic-Tac-Setting-awm-links-paypal" target="_blank" href="https://www.paypal.com/paypalme/acewebx">
                        <?php echo esc_html('You Liked It ? Donation'); ?> <img src="<?php echo esc_url( plugin_dir_url(__FILE__).'images/paypal-icon.png'); ?>"style="width:27px;">
                    </a>
                </div>
            </div>
            <form method="post" action="" id="tic_tack_toe_setting_form" enctype="multipart/form-data">
                <?php
                settings_fields('tic_tac_toe_settings_group');
                do_settings_sections('ace-tic-tac-toe-settings');
                submit_button();
                ?>
            </form>
        </div>
    <?php
    }

    // Register a new setting group for the plugin
    public function tic_tac_toe_register_settings()
    {
        register_setting('tic_tac_toe_settings_group', 'tic_tac_toe_options',  'tic_tac_toe_sanitize_options');
        add_settings_section('tic_tac_toe_general_section', '', array($this, 'tic_tac_toe_general_section_cb'), 'ace-tic-tac-toe-settings');
        $fields = [
            ['tic_tac_toe_shortcode_display', 'Shortcode', array($this, 'tic_tac_toe_shortcode_cb')],
            ['tic_tac_toe_game_title', 'Game Title', array($this, 'tic_tac_toe_game_title_cb')],
            ['tic_tac_toe_default_players', 'Players Name (X and O)', array($this, 'tic_tac_toe_default_players_cb')],
            ['tic_tac_toe_bg_color', 'Game Background Color', array($this, 'tic_tac_toe_bg_color_cb')],
            ['tic_tac_toe_button_color', 'Button Color (RGB)', array($this, 'tic_tac_toe_button_color_cb')],
            ['tic_tac_toe_play_type', 'Play Type', array($this, 'tic_tac_toe_play_type_cb')],
        ];
        foreach ($fields as $field) {
            add_settings_field(
                $field[0],
                $field[1],
                $field[2],
                'ace-tic-tac-toe-settings',
                'tic_tac_toe_general_section'
            );
        }
    }
    function tic_tac_toe_sanitize_options($input)
    {
        return sanitize_text_field($input);
    }
    function tic_tac_toe_enqueue_color_picker($hook_suffix)
    {
        if ($hook_suffix !== 'toplevel_page_ace-tic-tac-toe-settings') {
            return;
        }
        wp_enqueue_style('wp-color-picker');
        wp_enqueue_script('wp-color-picker');
        wp_add_inline_script('wp-color-picker', "
        jQuery(document).ready(function($) {
            $('#tic_tac_toe_button_color, .tic-tac-color-picker').wpColorPicker();
        });
    ");
    }
    function tic_tac_toe_shortcode_cb()
    {
    ?>
        <p>
            <strong id="tic-tac-shortcode">[ace_tic_tac_toe]</strong>
            <button type="button" class="button" id="copy_short_code">Copy</button>
        </p>
        <p class="description">Use this shortcode to embed the game in a post or page.</p>
    <?php
    }
    // Callback functions for settings fields
    function tic_tac_toe_general_section_cb() {}
    public function tic_tac_toe_game_title_cb()
    {
        $options = get_option('tic_tac_toe_options');
        $game_title = esc_attr($options['game_title'] ?? 'Ace Tic Tac Toe');
        $title_enable = !empty($options['title_enable']) ? 'checked' : '';
    ?>
        <label class="check-box-outer">
            <input type="checkbox" id="title_enable_checkbox" name="tic_tac_toe_options[title_enable]" value="1" <?php echo esc_attr($title_enable); ?> />
            <?php
            if (! empty($title)) {
                echo '<span style="margin-left: 8px;">' . esc_html($title) . '</span>';
            }
            ?>
        </label>

        <input type="text" id="game_title_input" name="tic_tac_toe_options[game_title]" value="<?php echo esc_attr($game_title); ?>" class="regular-text">
        <?php
    }
    public function tic_tac_toe_default_players_cb()
    {
        $upload_dir = wp_upload_dir();
        $url = esc_url($upload_dir['url']);
        $options = get_option('tic_tac_toe_options');
        $first_player_avtar_image = !empty($options['first_player_avtar']) ? $url . '/' . $options['first_player_avtar'] : '';
        $second_player_avtar_image = !empty($options['second_player_avtar']) ? $url . '/' . $options['second_player_avtar'] : '';
        $players = [
            'first_player' => [
                'label' => 'Player X',
                'value' => esc_attr($options['first_player'] ?? 'X'),
                'avatar' => $first_player_avtar_image,
                'avatar_field' => 'first_player_avtar',
                'placeholder' => esc_attr('Enter Symbol (X)')
            ],
            'second_player' => [
                'label' => 'Player O',
                'value' => esc_attr($options['second_player'] ?? 'O'),
                'avatar' => $second_player_avtar_image,
                'avatar_field' => 'second_player_avtar',
                'placeholder' => esc_attr('Enter Symbol (O)')
            ]
        ];
        foreach ($players as $key => $player) : ?>
            <div class="ttt-player-card">
                <label class="ttt-player-label"><?php echo esc_html($player['label']); ?></label>
                <input type="text" name="tic_tac_toe_options[<?php echo esc_attr($key); ?>]" value="<?php echo esc_attr($player['value']); ?>" maxlength="1" pattern="^[A-Za-z0-9]$" required placeholder="<?php echo esc_attr($player['placeholder']); ?>" class="ttt-player-input">
                <?php if (!empty($player['avatar'])) : ?>
                    <div class="ttt-avatar-preview">
                        <img src="<?php echo esc_url($player['avatar']); ?>" alt="<?php echo esc_attr($player['label'] . ' Avatar'); ?>" class="ttt-avatar-img">
                        <button type="submit" name="tic_tac_toe_delete_avatar" value="<?php echo esc_attr($key); ?>" class="ttt-delete-avatar-btn">&times;</button>
                    </div>
                <?php endif; ?>
                <input type="file" name="tic_tac_toe_options[<?php echo esc_attr($player['avatar_field']); ?>]" accept="image/*" class="ttt-file-input">
                <small class="ttt-avatar-instruction">Upload any avatar or player photo to represent Player. </small>
            </div>
        <?php endforeach; ?>
        <p class="description">Enter a single character (A-Z, 0-9) for each player.</p>
    <?php
    }
    function tic_tac_toe_bg_color_cb()
    {
        $options = get_option('tic_tac_toe_options');
        $bg_color = isset($options['bg_color']) ? $options['bg_color'] : '#ffffff';
    ?>
    <input type="text" name="tic_tac_toe_options[bg_color]" value="<?php echo esc_attr($bg_color); ?>" class="tic-tac-color-picker regular-text">
    <p class="description">Choose the background color for the Tic Tac Toe game (RGB or Hex).</p>
    <?php
    }
   function tic_tac_toe_button_color_cb() {
    $options = get_option('tic_tac_toe_options');
    $button_color = isset($options['button_color']) ? $options['button_color'] : '#000';  
    ?>
    <input type="text" name="tic_tac_toe_options[button_color]" value="<?php echo esc_attr($button_color); ?>" class="regular-text" id="tic_tac_toe_button_color">
    <p class="description">Enter the RGB or Hex value for the button color (e.g., rgb(0, 123, 255) for blue).</p>
        <?php
    }

    public function tic_tac_toe_play_type_cb()
    {
        $options = get_option('tic_tac_toe_options');

        if (!is_array($options)) {
            $options = [];
        }

        $selected = isset($options['play_type']) ? $options['play_type'] : 'single';
    ?>
        <select name="tic_tac_toe_options[play_type]">
            <option value="single" <?php selected($selected, 'single'); ?>>
                Single Player (Play with Computer)
            </option>
            <option value="multi" <?php selected($selected, 'multi'); ?>>
                Two Player (Play with Friend)
            </option>
        </select>
<?php
    }
    public function save_tic_tac_toe_settings()
    {
        if (isset($_POST['option_page']) && $_POST['option_page'] === 'tic_tac_toe_settings_group') {
            check_admin_referer('tic_tac_toe_settings_group-options');

            // Get existing options or empty array
            $options = get_option('tic_tac_toe_options', []);

            // Sanitize checkbox - present or not
            $options['title_enable'] = isset($_POST['tic_tac_toe_options']['title_enable']) ? 1 : 0;

            // Unsplash and sanitize text fields safely
            $options['game_title'] = isset($_POST['tic_tac_toe_options']['game_title'])
                ? sanitize_text_field(wp_unslash($_POST['tic_tac_toe_options']['game_title']))
                : '';

            $options['first_player'] = isset($_POST['tic_tac_toe_options']['first_player'])
                ? sanitize_text_field(wp_unslash($_POST['tic_tac_toe_options']['first_player']))
                : '';

            $options['second_player'] = isset($_POST['tic_tac_toe_options']['second_player'])
                ? sanitize_text_field(wp_unslash($_POST['tic_tac_toe_options']['second_player']))
                : '';

            $options['bg_color'] = isset($_POST['tic_tac_toe_options']['bg_color'])
                ? sanitize_text_field(wp_unslash($_POST['tic_tac_toe_options']['bg_color']))
                : '';

            $options['button_color'] = isset($_POST['tic_tac_toe_options']['button_color'])
                ? sanitize_text_field(wp_unslash($_POST['tic_tac_toe_options']['button_color']))
                : '';

            $options['play_type'] = isset($_POST['tic_tac_toe_options']['play_type'])
                ? sanitize_text_field(wp_unslash($_POST['tic_tac_toe_options']['play_type']))
                : '';

            $options['rows'] = isset($_POST['tic_tac_toe_options']['rows'])
                ? intval($_POST['tic_tac_toe_options']['rows'])
                : 3;

            $options['columns'] = isset($_POST['tic_tac_toe_options']['columns'])
                ? intval($_POST['tic_tac_toe_options']['columns'])
                : 3;

            // File Uploads - validate and sanitize properly
            foreach (['first_player_avtar', 'second_player_avtar'] as $key) {
                if (
                    !empty($_FILES['tic_tac_toe_options']['name'][$key]) &&
                    isset(
                        $_FILES['tic_tac_toe_options']['type'][$key],
                        $_FILES['tic_tac_toe_options']['tmp_name'][$key],
                        $_FILES['tic_tac_toe_options']['error'][$key],
                        $_FILES['tic_tac_toe_options']['size'][$key]
                    )
                ) {
                    $file = [
                        'name'     => sanitize_file_name($_FILES['tic_tac_toe_options']['name'][$key]),
                        'type'     => sanitize_mime_type($_FILES['tic_tac_toe_options']['type'][$key]),
                        'tmp_name' => sanitize_text_field($_FILES['tic_tac_toe_options']['tmp_name'][$key]),
                        'error'    => intval($_FILES['tic_tac_toe_options']['error'][$key]),
                        'size'     => intval($_FILES['tic_tac_toe_options']['size'][$key]),
                    ];

                    $upload = wp_handle_upload($file, ['test_form' => false]);

                    if (!isset($upload['error'])) {
                        $relative_path = str_replace(wp_upload_dir()['url'] . '/', '', $upload['url']);
                        $options[$key] = $relative_path;
                    }
                }
            }
            update_option('tic_tac_toe_options', $options);
        }
    }

    public function delete_tic_tac_toe_avatar_callback()
    {
        check_ajax_referer('delete_avatar_nonce', 'security');
        if (!current_user_can('manage_options')) {
            wp_send_json_error(array('message' => 'You do not have permission.'));
        }
        if (isset($_POST['player_key'])) {
            $player_key = sanitize_text_field(wp_unslash($_POST['player_key']));
        } else {
            $player_key = '';
        }
        $options = get_option('tic_tac_toe_options');
        $upload_dir = wp_upload_dir();
        if ($player_key === 'first_player' && !empty($options['first_player_avtar'])) {
            $file_path = $upload_dir['basedir'] . '/' . $options['first_player_avtar'];
            if (file_exists($file_path)) {
                wp_delete_file($file_path);
            }

            unset($options['first_player_avtar']);
        } elseif ($player_key === 'second_player' && !empty($options['second_player_avtar'])) {
            $file_path = $upload_dir['basedir'] . '/' . $options['second_player_avtar'];
            if (file_exists($file_path)) {
                wp_delete_file($file_path);
            }

            unset($options['second_player_avtar']);
        } else {
            wp_send_json_error(array('message' => 'Invalid player key or no avatar found.'));
        }
        update_option('tic_tac_toe_options', $options);
        wp_send_json_success();
    }
}
