<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://acewebx.com
 * @since             1.0.0
 * @package           Ace_Tic_Tac_Toe
 *
 * @wordpress-plugin
 * Plugin Name:       Ace Tic Tac Toe
 * Plugin URI:        https://acewebx.com
 * Description:       Bring classic fun to your WordPress site with the Ace Tic Tac Toe Game plugin! Lightweight and responsive, it allows visitors to play the game on pages or posts via a shortcode. Choose between two-player mode or AI mode. Built with HTML5, CSS, and JavaScript.
 * Version:           1.0.6
 * Requires at least: 6.2
 * Tested up to:      6.8
 * Requires PHP:      7.2
 * Author:            AceWebx Team
 * Author URI:        https://acewebx.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       ace-tic-tac-toe
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'ACE_TIC_TAC_TOE_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-ace-tic-tac-toe-activator.php
 */
function activate_ace_tic_tac_toe() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-ace-tic-tac-toe-activator.php';
	Ace_Tic_Tac_Toe_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-ace-tic-tac-toe-deactivator.php
 */
function deactivate_ace_tic_tac_toe() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-ace-tic-tac-toe-deactivator.php';
	Ace_Tic_Tac_Toe_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_ace_tic_tac_toe' );
register_deactivation_hook( __FILE__, 'deactivate_ace_tic_tac_toe' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-ace-tic-tac-toe.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_ace_tic_tac_toe() {

	$plugin = new Ace_Tic_Tac_Toe();
	$plugin->run();

}
run_ace_tic_tac_toe();
