<?php
/**
 * AccessiBar — Accessibility Toolbar
 *
 * @package AccessiBar
 *
 * Plugin Name: AccessiBar — Accessibility Toolbar
 * Description: A lightweight, GDPR-compliant accessibility toolbar. No external requests, no cookies, no subscriptions.
 * Version:     1.0.1
 * Author:      andreibarbashin
 * Author URI:  https://profiles.wordpress.org/andreibarbashin/
 * License:     GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: accessibar
 * Domain Path: /languages
 * Requires at least: 5.8
 * Tested up to:      6.9
 * Requires PHP: 7.4
 */

defined( 'ABSPATH' ) || exit;

define( 'ACCESSIBAR_VERSION', '1.0.1' );
define( 'ACCESSIBAR_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'ACCESSIBAR_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'ACCESSIBAR_OPTION_KEY', 'accessibar_options' );

require_once ACCESSIBAR_PLUGIN_DIR . 'includes/class-accessibar-admin.php';
require_once ACCESSIBAR_PLUGIN_DIR . 'includes/class-accessibar-frontend.php';

/**
 * Returns default plugin options.
 *
 * @return array Default options.
 */
function accessibar_get_defaults() {
	return array(
		'position'    => 'bottom-right',
		'color'       => '#0073e6',
		'size'        => 'medium',
		'button_text' => '',
		'hide_mobile' => false,
		'tools'       => array(
			'font_size'       => true,
			'high_contrast'   => true,
			'highlight_links' => true,
			'readable_font'   => true,
			'stop_animations' => true,
			'big_cursor'      => true,
		),
	);
}

/**
 * Returns merged plugin options with defaults.
 *
 * @return array Merged options.
 */
function accessibar_get_options() {
	$saved = get_option( ACCESSIBAR_OPTION_KEY, array() );

	if ( is_string( $saved ) ) {
		$saved = json_decode( $saved, true );
	}

	if ( ! is_array( $saved ) ) {
		$saved = array();
	}

	$defaults = accessibar_get_defaults();
	$options  = wp_parse_args( $saved, $defaults );

	if ( isset( $saved['tools'] ) && is_array( $saved['tools'] ) ) {
		$options['tools'] = wp_parse_args( $saved['tools'], $defaults['tools'] );
	}

	return $options;
}

add_action(
	'plugins_loaded',
	function () {
		if ( is_admin() ) {
			new AccessiBar_Admin();
		} else {
			new AccessiBar_Frontend();
		}
	}
);

register_activation_hook(
	__FILE__,
	function () {
		if ( false === get_option( ACCESSIBAR_OPTION_KEY ) ) {
			update_option( ACCESSIBAR_OPTION_KEY, accessibar_get_defaults() );
		}
	}
);
