<?php
/**
 * Rewrites Class
 *
 * @package Change_Login_URL
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Class ADALC_Rewrites
 */
class ADALC_Rewrites {

    /**
     * Constructor.
     */
    public function __construct() {
        add_action( 'init', array( $this, 'register_rewrites' ) );
        add_filter( 'query_vars', array( $this, 'add_query_vars' ) );
    }

    /**
     * Register custom rewrite rules.
     */
    public function register_rewrites() {
        $settings = get_option( 'ADALC_settings', array() );
        $enabled  = isset( $settings['enable_custom_login'] ) ? $settings['enable_custom_login'] : 0;

        if ( ! $enabled ) {
            return;
        }

        // Register role-based login URLs.
        if ( isset( $settings['role_slugs'] ) && is_array( $settings['role_slugs'] ) ) {
            foreach ( $settings['role_slugs'] as $role => $slug ) {
                if ( ! empty( $slug ) ) {
                    add_rewrite_rule(
                        '^' . $slug . '/?$',
                        'index.php?ADALC_login_role=' . $role,
                        'top'
                    );
                }
            }
        }
    }

    /**
     * Add custom query vars.
     *
     * @param array $vars Query vars.
     * @return array Modified query vars.
     */
    public function add_query_vars( $vars ) {
        $vars[] = 'ADALC_login_role';
        return $vars;
    }
}

// Initialize the rewrites class.
new ADALC_Rewrites();

/**
 * Helper function to register rewrites (used in activation hook).
 */
function ADALC_register_rewrites() {
    $settings = get_option( 'ADALC_settings', array() );
    $enabled  = isset( $settings['enable_custom_login'] ) ? $settings['enable_custom_login'] : 0;

    if ( ! $enabled ) { 
        return;
    }

    // Register role-based login URLs.
    if ( isset( $settings['role_slugs'] ) && is_array( $settings['role_slugs'] ) ) {
        foreach ( $settings['role_slugs'] as $role => $slug ) {
            if ( ! empty( $slug ) ) {
                add_rewrite_rule(
                    '^' . $slug . '/?$',
                    'index.php?ADALC_login_role=' . $role,
                    'top'
                );
            }
        }
    }
}