/**
 * Admin JavaScript for Change Admin Login URL plugin
 *
 * @package Change_Login_URL
 */

(function($) {
    'use strict';

    $(document).ready(function() {

        // Toggle required attribute for admin slug input when custom login is enabled
        var $customLoginToggle = $('input[name="ADALC_settings[enable_custom_login]"]');
        var $adminSlugInput = $('input[name="ADALC_settings[role_slugs][administrator]"]');

        function updateAdminSlugRequired() {
            if ($customLoginToggle.is(':checked')) {
                $adminSlugInput.attr('required', 'required');
            } else {
                $adminSlugInput.removeAttr('required');
            }
        }
        // Initial state
        updateAdminSlugRequired();
        // On toggle change
        $customLoginToggle.on('change', updateAdminSlugRequired);

        // enable redirection
        var $isRedirection = $('input[name="ADALC_settings[redirect_wp_login]"]');
        function showRedirectInput() {
            var $triggerRow = $("input[name='ADALC_settings[redirect_wp_login]']").closest('tr');
            var $nextRow = $triggerRow.next('tr');
            if ($isRedirection.is(':checked')) {
                $nextRow.show();
            } else {
                $nextRow.hide();
            }
        }
        // Initial state
        showRedirectInput();

        // enable redirection
        $isRedirection.on('change', showRedirectInput);


        // Copy URL to clipboard functionality
        $('.calu-copy-url').on('click', function(){
            var url = $(this).data('url');
            var $target = $('#' + $(this).data('target'));
            if (navigator.clipboard) {
                navigator.clipboard.writeText(url).then(function(){
                    $target.css('background','#d4edda');
                    setTimeout(function(){ $target.css('background',''); }, 700);
                });
            } else {
                var temp = $('<input>');
                $('body').append(temp);
                temp.val(url).select();
                document.execCommand('copy');
                temp.remove();
                $target.css('background','#d4edda');
                setTimeout(function(){ $target.css('background',''); }, 700);
            }
        });

                // var form = $('.calu-settings-form');
                // form.on('submit', function(e){
                //     var email = $('input[name="ADALC_settings[change_admin_email]"]').val();
                //     var username = $('input[name="ADALC_settings[change_admin_username]"]').val();
                //     var valid = true;
                //     var emailPattern = /^[^@\s]+@[^@\s]+\.[^@\s]+$/;
                //     if (!emailPattern.test(email)) {
                //         alert('Please enter a valid email address.');
                //         valid = false;
                //     }
                //     if (username.length < 3) {
                //         alert('Username must be at least 3 characters.');
                //         valid = false;
                //     }
                //     // AJAX check for existing email/username
                //     var ajaxDone = false;
                //     $.ajax({
                //         url: ajaxurl,
                //         type: 'POST',
                //         async: false,
                //         data: {
                //             action: 'adalc_check_user_exists',
                //             email: email,
                //             username: username
                //         },
                //         success: function(resp){
                //             if (resp.email_exists) {
                //                 alert('This email is already used.');
                //                 valid = false;
                //             }
                //             if (resp.username_exists) {
                //                 alert('This username is already used.');
                //                 valid = false;
                //             }
                //             ajaxDone = true;
                //         }
                //     });
                //     if (!valid || !ajaxDone) {
                //         e.preventDefault();
                //     }
                // });
            
        
        // Initialize accordion - show first item by default
        $('.calu-accordion-item.active .calu-accordion-content').show();
        
        // Accordion functionality
        $('.calu-accordion-header').on('click', function(e) {
            e.preventDefault();
            var $item = $(this).closest('.calu-accordion-item');
            var $content = $item.find('.calu-accordion-content');
            var isActive = $item.hasClass('active');
            
            // Close all accordion items
            $('.calu-accordion-item').removeClass('active');
            $('.calu-accordion-content').slideUp(300);
            
            // If the clicked item was not active, open it
            if (!isActive) {
                $item.addClass('active');
                $content.slideDown(300);
            }
        });
        
        // Sync color picker with text input
        $('.calu-color-picker').on('input change', function() {
            var role = $(this).data('role');
            var colorValue = $(this).val();
            $('.calu-color-value[data-role="' + role + '"]').val(colorValue);
            $('.accessdoor-login-preview[data-role="' + role + '"] .login-card').css('background-color', colorValue);  
        });

        // Sync text input with color picker
        $('.calu-color-value').on('input change', function() {
            var role = $(this).data('role');
            var colorValue = $(this).val();
            if (colorValue && /^#[0-9A-F]{6}$/i.test(colorValue)) {
                $('.calu-color-picker[data-role="' + role + '"]').val(colorValue);
            }
        });

        // Clear color button
        $('.calu-clear-color').on('click', function(e) {
            e.preventDefault();
            var role = $(this).data('role');
            $('.calu-color-value[data-role="' + role + '"]').val('');
            $('.calu-color-picker[data-role="' + role + '"]').val('#f0f0f1');
            $('.accessdoor-login-preview[data-role="' + role + '"] .login-card').css('background-color', '');
        });

        // WordPress Media Uploader for Logo
        $('.calu-upload-logo').on('click', function(e) {
            e.preventDefault();
            var button = $(this);
            var role = button.data('role');
            
            var mediaUploader = wp.media({
                title: 'Select Logo',
                button: {
                    text: 'Use this image'
                },
                multiple: false,
                library: {
                    type: 'image'
                }
            });
            // When an image is selected preview to accessdoor-login-preview and normal preview.
            mediaUploader.on('select', function() {
                var attachment = mediaUploader.state().get('selection').first().toJSON();
                $('.calu-logo-id[data-role="' + role + '"]').val(attachment.id);
                $('.calu-logo-preview[data-role="' + role + '"]').html('<img src="' + attachment.url + '" style="max-width: 200px; height: auto; display: block;" />');
                $('.accessdoor-login-preview[data-role="' + role + '"] .login-logo').attr('src', attachment.url);
                $('.calu-remove-logo[data-role="' + role + '"]').show();
            });

            mediaUploader.open();
        });

        // Remove Logo
        $('.calu-remove-logo').on('click', function(e) {
            e.preventDefault();
            var role = $(this).data('role');
            $('.calu-logo-id[data-role="' + role + '"]').val('');
            $('.calu-logo-preview[data-role="' + role + '"]').html('');
            $('.accessdoor-login-preview[data-role="' + role + '"] .login-logo').attr('src', '');
            $(this).hide();
        });

        // WordPress Media Uploader for Background Image
        $('.calu-upload-bg-image').on('click', function(e) {
            e.preventDefault();
            var button = $(this);
            var role = button.data('role');
            
            var mediaUploader = wp.media({
                title: 'Select Background Image',
                button: {
                    text: 'Use this image'
                },
                multiple: false,
                library: {
                    type: 'image'
                }
            });

            mediaUploader.on('select', function() {
                var attachment = mediaUploader.state().get('selection').first().toJSON();
                $('.calu-bg-image-id[data-role="' + role + '"]').val(attachment.id);
                $('.calu-bg-image-preview[data-role="' + role + '"]').html('<img src="' + attachment.url + '" style="max-width: 300px; height: auto; display: block;" />');
                $('.calu-remove-bg-image[data-role="' + role + '"]').show();
                $('.accessdoor-login-preview[data-role="' + role + '"] .login-card').css('background-image', 'url(' + attachment.url + ')');
            });

            mediaUploader.open();
        });

        // Remove Background Image
        $('.calu-remove-bg-image').on('click', function(e) {
            e.preventDefault();
            var role = $(this).data('role');
            $('.calu-bg-image-id[data-role="' + role + '"]').val('');
            $('.calu-bg-image-preview[data-role="' + role + '"]').html('');
            $(this).hide();
            $('.accessdoor-login-preview[data-role="' + role + '"] .login-card').css('background-image', 'none');   
        });

        $('.calu-copy-admin-design').on('click', function() {
            var currentRole = $(this).data('role');
            var adminRole = '';
            // Find the admin role slug (first role with name "Administrator")
            $('.calu-accordion-header .calu-accordion-title').each(function() {
                if ($(this).text().trim() === 'Administrator') {
                    adminRole = $(this).closest('.calu-accordion-header').data('role');
                }
            });
            if (!adminRole) return;

            // Get admin values
            var adminLogo = $('.calu-logo-id[data-role="' + adminRole + '"]').val();
            var adminLogoUrl = $('.calu-logo-preview[data-role="' + adminRole + '"] img').attr('src') || '';
            var adminBgImage = $('.calu-bg-image-id[data-role="' + adminRole + '"]').val();
            var adminBgImageUrl = $('.calu-bg-image-preview[data-role="' + adminRole + '"] img').attr('src') || '';
            var adminBgColor = $('.calu-color-value[data-role="' + adminRole + '"]').val();

            // Set current role values
            $('.calu-logo-id[data-role="' + currentRole + '"]').val(adminLogo);
            if (adminLogoUrl) {
                $('.calu-logo-preview[data-role="' + currentRole + '"]').html('<img src="' + adminLogoUrl + '" style="max-width: 200px; height: auto; display: block;" />');
                $('.accessdoor-login-preview[data-role="' + currentRole + '"] .login-logo').attr('src', adminLogoUrl);
                $('.calu-remove-logo[data-role="' + currentRole + '"]').show();
            } else {
                $('.calu-logo-preview[data-role="' + currentRole + '"]').html('');
                $('.accessdoor-login-preview[data-role="' + currentRole + '"] .login-logo').attr('src', '');
                $('.calu-remove-logo[data-role="' + currentRole + '"]').hide();
            }

            $('.calu-bg-image-id[data-role="' + currentRole + '"]').val(adminBgImage);
            if (adminBgImageUrl) {
                $('.calu-bg-image-preview[data-role="' + currentRole + '"]').html('<img src="' + adminBgImageUrl + '" style="max-width: 200px; height: auto; display: block;" />');
                $('.accessdoor-login-preview[data-role="' + currentRole + '"] .login-card').css('background-image', 'url(' + adminBgImageUrl + ')');
                $('.calu-remove-bg-image[data-role="' + currentRole + '"]').show();
            } else {
                $('.calu-bg-image-preview[data-role="' + currentRole + '"]').html('');
                $('.accessdoor-login-preview[data-role="' + currentRole + '"] .login-card').css('background-image', 'none');
                $('.calu-remove-bg-image[data-role="' + currentRole + '"]').hide();
            }

            $('.calu-color-value[data-role="' + currentRole + '"]').val(adminBgColor);
            $('.calu-color-picker[data-role="' + currentRole + '"]').val(adminBgColor);
            $('.accessdoor-login-preview[data-role="' + currentRole + '"] .login-card').css('background-color', adminBgColor);
        });

    });

})(jQuery);
