<?php
/*
 * Plugin Name:       AccessDoor - Smart Admin Login & Security
 * Plugin URI:        https://wordpress.org/plugins/accessdoor-smart-admin-login-url-control/
 * Description:       Create custom login URLs for admins and user roles. Hide wp-login.php and improve WordPress security with role-based access.
 * Version:           1.0.3
 * Requires at least: 6.0
 * Tested up to:      6.9
 * Requires PHP:      7.4
 * Author:            IT Path Solutions
 * Author URI:        https://www.itpathsolutions.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       accessdoor-smart-admin-login-url-control
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'ADALC_VERSION', '1.0.3' );
define( 'ADALC_PATH', plugin_dir_path( __FILE__ ) );
define( 'ADALC_URL', plugin_dir_url( __FILE__ ) );


// Ensure class-rewrites.php is loaded before activation hook
if ( file_exists( ADALC_PATH . 'includes/class-rewrites.php' ) ) {
    require_once ADALC_PATH . 'includes/class-rewrites.php';
}

/**
 * Activation hook
 */
register_activation_hook( __FILE__, 'ADALC_activate' );
function ADALC_activate() {
    if ( function_exists( 'ADALC_register_rewrites' ) ) {
        ADALC_register_rewrites();
    }
    flush_rewrite_rules();
    // Ensure class-admin.php is loaded
    if ( ! class_exists( 'ADALC_Admin' ) && file_exists( ADALC_PATH . 'includes/class-admin.php' ) ) {
        require_once ADALC_PATH . 'includes/class-admin.php';
    }
    $settings = get_option( 'ADALC_settings', [] );
    $admin = new ADALC_Admin();
    // Re-run the same logic as update handler
    $admin->handle_settings_update( [], $settings );
}

/**
 * Deactivation hook
 */

register_deactivation_hook( __FILE__, 'ADALC_deactivate' );
function ADALC_deactivate() {
    flush_rewrite_rules();

    // remove all htaccess rules added by the plugin
    if ( ! function_exists( 'request_filesystem_credentials' ) ) {
        require_once ABSPATH . 'wp-admin/includes/file.php';
    }

    global $wp_filesystem;

    if ( empty( $wp_filesystem ) ) {
        $creds = request_filesystem_credentials( '', '', false, false, null );
        if ( ! WP_Filesystem( $creds ) ) {
            return;
        }
    }

    // Remove root htaccess block
    $htaccess_path = ABSPATH . '.htaccess';

    if ( $wp_filesystem->exists( $htaccess_path ) ) {
        $contents = $wp_filesystem->get_contents( $htaccess_path );
        $cleaned  = preg_replace(
            '/# BEGIN Accessdoor Directory Protection.*?# END Accessdoor Directory Protection\n?/s',
            '',
            $contents
        );
        $wp_filesystem->put_contents( $htaccess_path, $cleaned, FS_CHMOD_FILE );
    }

    // Remove uploads htaccess block
    $uploads_dir = wp_get_upload_dir();
    $uploads_htaccess = trailingslashit( $uploads_dir['basedir'] ) . '.htaccess';

    if ( $wp_filesystem->exists( $uploads_htaccess ) ) {
        $contents = $wp_filesystem->get_contents( $uploads_htaccess );
        $cleaned  = preg_replace(
            '/# BEGIN Accessdoor Upload Protection.*?# END Accessdoor Upload Protection\n?/s',
            '',
            $contents
        );
        $wp_filesystem->put_contents( $uploads_htaccess, $cleaned, FS_CHMOD_FILE );
    }
}

/**
 * Load plugin files.
 */
add_action( 'plugins_loaded', 'ADALC_init' );
function ADALC_init() {
    $includes = array(
        ADALC_PATH . 'includes/class-rewrites.php',
        ADALC_PATH . 'includes/class-login-handler.php',
        ADALC_PATH . 'includes/class-admin.php',
    );
    foreach ( $includes as $file ) {
        if ( file_exists( $file ) ) {
            require_once $file;
        } else {
            // Optional: Log error or handle missing file gracefully
            // error_log( 'Change Login URL plugin: Missing required file: ' . $file );
        }
    }
}

// add_action( 'update_option_admin_email', function () {
//     delete_option( 'adminhash' );
//     delete_option( 'new_admin_email' );
// }, 10, 0 );


// AJAX handler for username/email existence check
add_action('wp_ajax_adalc_check_user_exists', function() {
    check_ajax_referer( 'adalc_ajax_nonce', 'nonce' );
    $email = isset($_POST['email']) ? sanitize_email( wp_unslash( $_POST['email'] ) ) : '';
    $username = isset($_POST['username']) ? sanitize_user( wp_unslash( $_POST['username'] ) ) : '';
    $resp = array('email_exists' => false, 'username_exists' => false);
    if ($email && email_exists($email)) {
        $resp['email_exists'] = true;
    }
    if ($username && username_exists($username)) {
        $resp['username_exists'] = true;
    }
    wp_send_json($resp);
});

// Initialize the admin class only once after all plugin files are loaded.
add_action( 'plugins_loaded', function() {
    if ( class_exists( 'ADALC_Admin' ) ) {
        new ADALC_Admin();
        
    }
});