<?php
/**
 * Admin settings page view.
 *
 * Variables available from Settings::render_settings_page():
 *   $tabs         array  Slug => label map.
 *   $active_tab   string Current tab slug.
 *   $ab_svg_kses  array  wp_kses allowlist for inline SVG tab icons.
 *   $ab_tab_icons array  Slug => SVG string map.
 *
 * @package AbstractBox
 */
defined( 'ABSPATH' ) || exit;
?>
<div class="wrap abstract-box-settings">

    <?php /* WP requires an <h1> in .wrap for notices to anchor to. Hidden via CSS. */ ?>
    <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

    <!-- ── Header card ─────────────────────────────────────────────── -->
    <div class="ab-header">
        <div class="ab-header__left">
            <div class="ab-header__icon" aria-hidden="true">
                <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                    <path d="M4 4h16v2H4V4zm0 4h16v2H4V8zm0 4h10v2H4v-2zm0 4h16v2H4v-2z"/>
                </svg>
            </div>
            <div>
                <div class="ab-header__title"><?php esc_html_e( 'Abstract Box', 'abstract-box' ); ?></div>
                <div class="ab-header__subtitle"><?php esc_html_e( 'Structured academic abstract blocks for WordPress', 'abstract-box' ); ?></div>
            </div>
        </div>
        <div class="ab-header__meta">
            <span class="ab-header__version">v<?php echo esc_html( ABSTRACT_BOX_VERSION ); ?></span>
        </div>
    </div><!-- .ab-header -->

    <!-- ── Tab navigation ──────────────────────────────────────────── -->
    <nav class="nav-tab-wrapper abstract-box-tabs" role="tablist" aria-label="<?php esc_attr_e( 'Settings sections', 'abstract-box' ); ?>">
        <?php
        // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- $slug, $label are foreach iteration vars local to this template, not globals.
        foreach ( $tabs as $slug => $label ) :
            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- template locals, not globals.
            $ab_tab_url   = add_query_arg(
                array( 'page' => 'abstract-box', 'tab' => $slug ),
                admin_url( 'options-general.php' )
            );
            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- template locals, not globals.
            $ab_is_active = ( $active_tab === $slug );
            // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- template locals, not globals.
            $ab_icon_html = isset( $ab_tab_icons[ $slug ] ) ? $ab_tab_icons[ $slug ] : '';
        ?>
            <a href="<?php echo esc_url( $ab_tab_url ); ?>"
               class="nav-tab <?php echo $ab_is_active ? 'nav-tab-active' : ''; ?>"
               role="tab"
               aria-selected="<?php echo $ab_is_active ? 'true' : 'false'; ?>">
                <?php echo wp_kses( $ab_icon_html, $ab_svg_kses ); ?>
                <?php echo esc_html( $label ); ?>
            </a>
        <?php endforeach; ?>
    </nav>

    <!-- ── Tab panel ───────────────────────────────────────────────── -->
    <div class="ab-tab-panel" role="tabpanel">

        <?php if ( 'usage' === $active_tab ) : ?>

            <?php include ABSTRACT_BOX_DIR . 'includes/views/usage.php'; ?>

        <?php else : ?>

            <form method="post" action="options.php" class="abstract-box-form">
                <?php wp_nonce_field( 'ab_settings_save', 'ab_settings_nonce' ); ?>
                <?php
                switch ( $active_tab ) {
                    case 'schema':
                        $this->render_schema_tab();
                        break;
                    case 'advanced':
                        $this->render_advanced_tab();
                        break;
                    default:
                        $this->render_appearance_tab();
                        break;
                }

                $this->hidden_fields_for_inactive_tabs( $active_tab );
                ?>
                <div class="submit">
                    <input type="submit"
                           name="submit"
                           id="submit"
                           class="button button-primary"
                           value="<?php esc_attr_e( 'Save Settings', 'abstract-box' ); ?>" />
                </div>
            </form>

            <?php if ( ! in_array( $active_tab, array( 'schema', 'advanced' ), true ) ) : ?>
            <div class="abstract-box-preview-panel">
                <h3><?php esc_html_e( 'Preview', 'abstract-box' ); ?></h3>
                <div class="abstract-box-preview-container">
                    <?php
                    echo wp_kses(
                        $this->render_preview(),
                        array(
                            'div' => array( 'id' => array(), 'class' => array(), 'style' => array() ),
                            'p'   => array(),
                        )
                    );
                    ?>
                </div>
            </div>
            <?php endif; ?>

        <?php endif; ?>

    </div><!-- .ab-tab-panel -->

    <!-- ── Footer ──────────────────────────────────────────────────── -->
    <footer class="ab-footer">
        <p>
            <?php
            printf(
                /* translators: %s: linked author name */
                esc_html__( 'Developed by %s', 'abstract-box' ),
                '<a href="https://github.com/menj" target="_blank" rel="noopener noreferrer">MENJ</a>'
            );
            ?>
        </p>
    </footer>

</div><!-- .wrap.abstract-box-settings -->
