<?php
/**
 * Fired during plugin deactivation.
 *
 * @link       https://example.com
 * @since      1.0.0
 *
 * @package    A1AI
 * @subpackage A1AI/includes
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    A1AI
 * @subpackage A1AI/includes
 * @author     A1AI <info@example.com>
 */
class A1AI_Deactivator {

    /**
     * Run plugin deactivation tasks.
     *
     * Clean up transients and perform other deactivation tasks.
     * We don't delete any tables or options to preserve user data.
     *
     * @since    1.0.0
     */
    public static function deactivate() {
        // Clean up transients
        delete_transient('a1ai_activation_redirect');
        delete_transient('a1ai_usage_stats_cache');
        
        // We don't remove database tables or plugin options on deactivation
        // to ensure user data persists if they reactivate the plugin
        
        // Optionally in the future, we could add a setting to let users
        // decide if they want to remove data on deactivation
        
        // Clear any scheduled events
        self::clear_scheduled_events();
    }
    
    /**
     * Clear any scheduled events created by the plugin.
     *
     * @since    1.0.0
     */
    private static function clear_scheduled_events() {
        $timestamp = wp_next_scheduled('a1ai_daily_maintenance');
        if ($timestamp) {
            wp_unschedule_event($timestamp, 'a1ai_daily_maintenance');
        }
        
        // Clear any other scheduled events here
    }
} 