<?php
/**
 * Admin upgrade tab template
 *
 * @link       https://a1aidigital.com
 * @since      1.0.0
 *
 * @package    A1AI
 * @subpackage A1AI/admin/partials
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
?>

<div class="a1ai-upgrade-container">
    <div class="a1ai-upgrade-hero" style="background: linear-gradient(135deg, #0073aa 0%, #005177 100%); color: white; padding: 40px; border-radius: 12px; text-align: center; margin-bottom: 30px;">
        <h1 style="color: white; margin: 0 0 15px 0; font-size: 2.5em;">🚀 Upgrade to A1AI Pro</h1>
        <p style="font-size: 1.2em; margin: 0; opacity: 0.9;">Unlock the full potential of your AI chatbot with premium features</p>
    </div>

    <div class="a1ai-upgrade-features" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 25px; margin-bottom: 40px;">

        <!-- Advanced Adjustments -->
        <div class="a1ai-feature-card" style="background: white; border: 1px solid #ddd; border-radius: 8px; padding: 25px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
            <div style="background: #e7f3ff; width: 60px; height: 60px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 20px;">
                <span style="font-size: 24px;">⚙️</span>
            </div>
            <h3 style="margin: 0 0 15px 0; color: #0073aa;">Advanced Adjustments</h3>
            <ul style="margin: 0; padding-left: 20px; line-height: 1.6;">
                <li><strong>Broad Matching:</strong> Flexible pattern matching with required keywords</li>
                <li><strong>Phrase Matching:</strong> Core phrase detection with variations</li>
                <li><strong>Exact Matching:</strong> Precise verbatim pattern matching</li>
                <li><strong>Temperature Control:</strong> Fine-tune AI creativity and consistency</li>
                <li><strong>One-Click Creation:</strong> Create adjustments directly from conversations</li>
            </ul>
        </div>

        <!-- Contact Forms -->
        <div class="a1ai-feature-card" style="background: white; border: 1px solid #ddd; border-radius: 8px; padding: 25px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
            <div style="background: #fff2e7; width: 60px; height: 60px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 20px;">
                <span style="font-size: 24px;">📝</span>
            </div>
            <h3 style="margin: 0 0 15px 0; color: #d54e21;">Smart Contact Forms</h3>
            <ul style="margin: 0; padding-left: 20px; line-height: 1.6;">
                <li><strong>Traditional Forms:</strong> Standard contact form integration</li>
                <li><strong>Hybrid Chat+Form:</strong> Dynamic question flows before submission</li>
                <li><strong>Organic Chat:</strong> Natural conversation-based lead capture</li>
                <li><strong>Custom Fields:</strong> Unlimited field types and validation</li>
                <li><strong>Email Notifications:</strong> Automated lead alerts</li>
            </ul>
        </div>

        <!-- Reviews Management -->
        <div class="a1ai-feature-card" style="background: white; border: 1px solid #ddd; border-radius: 8px; padding: 25px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
            <div style="background: #f0f8ff; width: 60px; height: 60px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 20px;">
                <span style="font-size: 24px;">⭐</span>
            </div>
            <h3 style="margin: 0 0 15px 0; color: #0073aa;">Review Management</h3>
            <ul style="margin: 0; padding-left: 20px; line-height: 1.6;">
                <li><strong>Review Collection:</strong> Automated review requests</li>
                <li><strong>Multiple Platforms:</strong> Google, Yelp, Facebook integration</li>
                <li><strong>Smart Filtering:</strong> Route reviews based on ratings</li>
                <li><strong>Analytics Dashboard:</strong> Detailed review insights</li>
                <li><strong>Sentiment Analysis:</strong> Understand customer feedback</li>
            </ul>
        </div>

        <!-- Advanced Analytics -->
        <div class="a1ai-feature-card" style="background: white; border: 1px solid #ddd; border-radius: 8px; padding: 25px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
            <div style="background: #e8f5e8; width: 60px; height: 60px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 20px;">
                <span style="font-size: 24px;">📊</span>
            </div>
            <h3 style="margin: 0 0 15px 0; color: #2d7d2d;">Advanced Analytics</h3>
            <ul style="margin: 0; padding-left: 20px; line-height: 1.6;">
                <li><strong>Conversation Insights:</strong> Detailed chat analytics</li>
                <li><strong>User Journey Tracking:</strong> Follow visitor interactions</li>
                <li><strong>Performance Metrics:</strong> Conversion and engagement stats</li>
                <li><strong>Custom Reports:</strong> Tailored business insights</li>
                <li><strong>Export Options:</strong> Data export for external analysis</li>
            </ul>
        </div>

        <!-- Premium Support -->
        <div class="a1ai-feature-card" style="background: white; border: 1px solid #ddd; border-radius: 8px; padding: 25px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
            <div style="background: #f3e8ff; width: 60px; height: 60px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 20px;">
                <span style="font-size: 24px;">🎧</span>
            </div>
            <h3 style="margin: 0 0 15px 0; color: #7c3aed;">Premium Support</h3>
            <ul style="margin: 0; padding-left: 20px; line-height: 1.6;">
                <li><strong>Priority Support:</strong> Skip the queue for faster help</li>
                <li><strong>Phone Support:</strong> Direct access to our experts</li>
                <li><strong>Custom Setup:</strong> Personalized chatbot configuration</li>
                <li><strong>Training Sessions:</strong> One-on-one optimization guidance</li>
                <li><strong>Regular Updates:</strong> Early access to new features</li>
            </ul>
        </div>

        <!-- Custom Integrations -->
        <div class="a1ai-feature-card" style="background: white; border: 1px solid #ddd; border-radius: 8px; padding: 25px; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
            <div style="background: #fff0f0; width: 60px; height: 60px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-bottom: 20px;">
                <span style="font-size: 24px;">🔗</span>
            </div>
            <h3 style="margin: 0 0 15px 0; color: #dc2626;">Custom Integrations</h3>
            <ul style="margin: 0; padding-left: 20px; line-height: 1.6;">
                <li><strong>CRM Integration:</strong> Sync with Salesforce, HubSpot, etc.</li>
                <li><strong>Email Marketing:</strong> Connect to Mailchimp, Constant Contact</li>
                <li><strong>E-commerce:</strong> WooCommerce and Shopify integration</li>
                <li><strong>Webhook Support:</strong> Connect to any third-party service</li>
                <li><strong>API Access:</strong> Full programmatic control</li>
            </ul>
        </div>

    </div>

    <!-- Pricing Section -->
    <div class="a1ai-pricing-section" style="background: #f9f9f9; border-radius: 12px; padding: 40px; text-align: center; margin-bottom: 30px;">
        <h2 style="margin: 0 0 20px 0; color: #333;">Ready to Upgrade?</h2>
        <p style="font-size: 1.1em; color: #666; margin: 0 0 30px 0;">Get all premium features and transform your customer interactions</p>

        <div style="background: white; border-radius: 8px; padding: 30px; display: inline-block; box-shadow: 0 4px 12px rgba(0,0,0,0.1);">
            <h3 style="margin: 0 0 15px 0; color: #0073aa;">Contact A1AI Digital</h3>
            <p style="margin: 0 0 20px 0; color: #666;">Get a custom quote tailored to your business needs</p>

            <div style="display: flex; justify-content: center; gap: 30px; margin-bottom: 20px; flex-wrap: wrap;">
                <div style="text-align: center;">
                    <div style="background: #0073aa; color: white; width: 50px; height: 50px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 10px auto;">
                        <span style="font-size: 20px;">📧</span>
                    </div>
                    <strong>Email:</strong><br>
                    <a href="mailto:contact@a1aidigital.com" style="color: #0073aa; text-decoration: none;">contact@a1aidigital.com</a>
                </div>

                <div style="text-align: center;">
                    <div style="background: #0073aa; color: white; width: 50px; height: 50px; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 10px auto;">
                        <span style="font-size: 20px;">📞</span>
                    </div>
                    <strong>Phone:</strong><br>
                    <a href="tel:801-893-1686" style="color: #0073aa; text-decoration: none;">801-893-1686</a>
                </div>
            </div>

            <div style="background: #e7f3ff; border-radius: 6px; padding: 15px; margin-top: 20px;">
                <p style="margin: 0; color: #0073aa; font-weight: 600;">
                    💡 <strong>Free Consultation:</strong> Schedule a call to discuss your specific needs and get a personalized demo
                </p>
            </div>
        </div>
    </div>

    <!-- Why Choose A1AI -->
    <div class="a1ai-why-choose" style="background: white; border: 1px solid #ddd; border-radius: 8px; padding: 30px;">
        <h2 style="margin: 0 0 20px 0; text-align: center; color: #333;">Why Choose A1AI Digital?</h2>

        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
            <div style="text-align: center;">
                <div style="font-size: 48px; margin-bottom: 10px;">🏆</div>
                <h4 style="margin: 0 0 10px 0; color: #0073aa;">Industry Leaders</h4>
                <p style="margin: 0; color: #666;">Pioneers in AI chatbot technology with years of WordPress expertise</p>
            </div>

            <div style="text-align: center;">
                <div style="font-size: 48px; margin-bottom: 10px;">🔒</div>
                <h4 style="margin: 0 0 10px 0; color: #0073aa;">Secure & Reliable</h4>
                <p style="margin: 0; color: #666;">Enterprise-grade security with 99.9% uptime guarantee</p>
            </div>

            <div style="text-align: center;">
                <div style="font-size: 48px; margin-bottom: 10px;">⚡</div>
                <h4 style="margin: 0 0 10px 0; color: #0073aa;">Lightning Fast</h4>
                <p style="margin: 0; color: #666;">Optimized for speed with global CDN and smart caching</p>
            </div>

            <div style="text-align: center;">
                <div style="font-size: 48px; margin-bottom: 10px;">🎯</div>
                <h4 style="margin: 0 0 10px 0; color: #0073aa;">Results Driven</h4>
                <p style="margin: 0; color: #666;">Proven to increase conversions and customer satisfaction</p>
            </div>
        </div>
    </div>
</div>

<style>
.a1ai-upgrade-container h1,
.a1ai-upgrade-container h2,
.a1ai-upgrade-container h3,
.a1ai-upgrade-container h4 {
    font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
}

.a1ai-feature-card {
    transition: transform 0.2s ease, box-shadow 0.2s ease;
}

.a1ai-feature-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 4px 20px rgba(0,0,0,0.15) !important;
}

@media (max-width: 768px) {
    .a1ai-upgrade-hero {
        padding: 25px !important;
    }

    .a1ai-upgrade-hero h1 {
        font-size: 1.8em !important;
    }

    .a1ai-pricing-section > div {
        padding: 20px !important;
    }

    .a1ai-pricing-section > div > div {
        flex-direction: column !important;
        gap: 20px !important;
    }
}
</style>
