<?php
/**
 * Admin dashboard template
 *
 * @link       https://a1aidigital.com
 * @since      1.0.0
 *
 * @package    A1AI
 * @subpackage A1AI/admin/partials
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Get usage statistics
$usage_stats = $data_manager->get_usage_stats('month');
$totals = $usage_stats['totals'] ?? array(
    'message_count' => 0,
    'tokens_used' => 0,
    'conversation_count' => 0,
);

// Check if upgrade plugin is active
$upgrade_active = class_exists('A1AI_Upgrade_Helper') && A1AI_Upgrade_Helper::is_upgrade_active();
?>

<div class="a1ai-wrap">
    <div class="a1ai-header">
        <h1><?php echo esc_html__('A1AI Chatbot Dashboard', 'a1ai-chatbot'); ?></h1>
        <div class="a1ai-header-actions">
            <a href="<?php echo esc_url(admin_url('admin.php?page=a1ai-chatbots&action=add')); ?>" class="button button-primary">
                <?php echo esc_html__('Add New Chatbot', 'a1ai-chatbot'); ?>
            </a>
        </div>
    </div>

    <div class="a1ai-notices"></div>
    
    <?php
    // Check if API key is set
    $api_key = get_option('a1ai_openai_api_key', '');
    if (empty($api_key)) {
        ?>
        <div class="a1ai-notice a1ai-notice-warning">
            <p>
                <?php echo esc_html__('The OpenAI API key is not set. Please configure it in the', 'a1ai-chatbot'); ?>
                <a href="<?php echo esc_url(admin_url('admin.php?page=a1ai-settings')); ?>"><?php echo esc_html__('Settings', 'a1ai-chatbot'); ?></a>
                <?php echo esc_html__('page to start using the chatbot.', 'a1ai-chatbot'); ?>
            </p>
        </div>
        <?php
    }
    ?>
    
    <div class="a1ai-dashboard-grid">
        <!-- AI Chatbot Assistant Section -->
        <div class="a1ai-card a1ai-assistant-card">
            <h3><?php echo esc_html__('A1AI Chatbot Assistant', 'a1ai-chatbot'); ?></h3>
            <div class="a1ai-assistant-container">
                <div class="a1ai-assistant-messages" id="a1ai-assistant-messages">
                    <!-- Initial welcome message -->
                    <div class="a1ai-assistant-message a1ai-assistant-bot">
                        <div class="a1ai-assistant-avatar">
                            <div class="a1ai-logo-container">
                                <?php
                                $logo_url = plugins_url('assets/images/square-logo-tiny1.png', dirname(dirname(__FILE__)));
                                $logo_exists = file_exists(plugin_dir_path(dirname(dirname(__FILE__))) . 'assets/images/square-logo-tiny1.png');

                                if ($logo_exists) {
                                    // Use direct img tag for plugin file
                                    echo '<img src="' . esc_url($logo_url) . '" alt="' . esc_attr__('A1AI Logo', 'a1ai-chatbot') . '" class="a1ai-logo-img" width="24" height="24" loading="lazy" decoding="async" />';
                                } else {
                                    echo '<span class="a1ai-logo-fallback" style="font-size: 24px;">🤖</span>';
                                }
                                ?>
                            </div>
                        </div>
                        <div class="a1ai-assistant-content">
                            <?php if (empty($api_key)): ?>
                                <p><strong><?php echo esc_html__('Welcome! I\'m your A1AI Chatbot Assistant.', 'a1ai-chatbot'); ?></strong></p>
                                <p><?php echo esc_html__('I notice you haven\'t set up your OpenAI API key yet. No worries - I can help you get started in just a few minutes!', 'a1ai-chatbot'); ?></p>
                                <p><?php echo esc_html__('Would you like me to guide you through the setup, or would you prefer to have A1AI\'s team handle the complete setup for you?', 'a1ai-chatbot'); ?></p>
                                <p>
                                    <a href="<?php echo esc_url(admin_url('admin.php?page=a1ai-settings#tab-general')); ?>" class="button button-primary" style="margin-right: 10px;">
                                        <?php echo esc_html__('I\'ll Set It Up Myself', 'a1ai-chatbot'); ?>
                                    </a>
                                    <a href="mailto:contact@a1aidigital.com?subject=Professional Setup Request" class="button">
                                        <?php echo esc_html__('Get Professional Setup', 'a1ai-chatbot'); ?>
                                    </a>
                                </p>
                            <?php else: ?>
                                <?php if ($upgrade_active): ?>
                                    <p><strong><?php echo esc_html__('Hey there! 👋 Welcome back, Premium User!', 'a1ai-chatbot'); ?></strong></p>
                                    <p><?php echo esc_html__('You\'re using the A1AI Premium version with all advanced features unlocked. I\'m here to help you get the most out of your investment!', 'a1ai-chatbot'); ?></p>
                                    <p><?php echo esc_html__('What can I help you with today?', 'a1ai-chatbot'); ?></p>
                                    <ul style="margin: 10px 0; padding-left: 20px; color: #666;">
                                        <li><?php echo esc_html__('Optimizing your premium features', 'a1ai-chatbot'); ?></li>
                                        <li><?php echo esc_html__('Boosting conversions and performance', 'a1ai-chatbot'); ?></li>
                                        <li><?php echo esc_html__('Troubleshooting or technical help', 'a1ai-chatbot'); ?></li>
                                        <li><?php echo esc_html__('Learning about done-for-you management services', 'a1ai-chatbot'); ?></li>
                                    </ul>
                                    <p style="font-size: 13px; color: #666; margin-top: 10px;"><em><?php echo esc_html__('Pro tip: Spending 3+ hours/week managing your chatbot? Ask me about our Managed Services!', 'a1ai-chatbot'); ?></em></p>
                                <?php else: ?>
                                    <p><strong><?php echo esc_html__('Hey there! 👋 I\'m your A1AI Chatbot Assistant.', 'a1ai-chatbot'); ?></strong></p>
                                    <p><?php echo esc_html__('You\'re using the free version - great for getting started! I\'m here to help you succeed and show you how to unlock even more powerful features.', 'a1ai-chatbot'); ?></p>
                                    <p><?php echo esc_html__('What brings you here today?', 'a1ai-chatbot'); ?></p>
                                    <ul style="margin: 10px 0; padding-left: 20px; color: #666;">
                                        <li><?php echo esc_html__('Getting started / setup help', 'a1ai-chatbot'); ?></li>
                                        <li><?php echo esc_html__('Improving my chatbot\'s performance', 'a1ai-chatbot'); ?></li>
                                        <li><?php echo esc_html__('Unlocking premium features (Smart Forms, Reviews, Analytics)', 'a1ai-chatbot'); ?></li>
                                        <li><?php echo esc_html__('Exploring done-for-you management services', 'a1ai-chatbot'); ?></li>
                                    </ul>
                                    <p style="font-size: 13px; color: #666; margin-top: 10px;"><em><?php echo esc_html__('Pro tip: Want to capture 40-70% more leads? Ask me about Premium features!', 'a1ai-chatbot'); ?></em></p>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="a1ai-assistant-input">
                    <input type="text" id="a1ai-assistant-input" placeholder="<?php echo esc_attr__('Type your message here...', 'a1ai-chatbot'); ?>" />
                    <button type="button" id="a1ai-assistant-send" class="button button-primary">
                        <?php echo esc_html__('Send', 'a1ai-chatbot'); ?>
                    </button>
                </div>
                
                <!-- Quick action buttons -->
                <div class="a1ai-assistant-quick-actions">
                    <button type="button" class="a1ai-assistant-quick-btn" data-action="setup-openai">
                        <?php echo esc_html__('🚀 Quick Setup Guide', 'a1ai-chatbot'); ?>
                    </button>
                    <button type="button" class="a1ai-assistant-quick-btn" data-action="help-support">
                        <?php echo esc_html__('🔧 Troubleshooting Help', 'a1ai-chatbot'); ?>
                    </button>
                    <button type="button" class="a1ai-assistant-quick-btn" data-action="premium-features">
                        <?php echo esc_html__('⭐ Unlock Premium Features', 'a1ai-chatbot'); ?>
                    </button>
                    <button type="button" class="a1ai-assistant-quick-btn" data-action="management-services">
                        <?php echo esc_html__('💼 Done-For-You Service', 'a1ai-chatbot'); ?>
                    </button>
                </div>
            </div>
        </div>
        
        <div class="a1ai-card">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h3 style="margin: 0;"><?php echo esc_html__('Usage Statistics', 'a1ai-chatbot'); ?></h3>
                <?php if ($upgrade_active): ?>
                <div class="a1ai-export-buttons">
                    <button type="button" id="a1ai-export-csv" class="button">
                        <?php echo esc_html__('Export CSV', 'a1ai-chatbot'); ?>
                    </button>
                    <button type="button" id="a1ai-export-json" class="button">
                        <?php echo esc_html__('Export JSON', 'a1ai-chatbot'); ?>
                    </button>
                </div>
                <?php else: ?>
                <div class="a1ai-upgrade-notice-inline">
                    <a href="<?php echo esc_url(admin_url('admin.php?page=a1ai-settings#tab-upgrades')); ?>" class="button button-secondary">
                        <?php echo esc_html__('Upgrade to Export Data', 'a1ai-chatbot'); ?>
                    </a>
                </div>
                <?php endif; ?>
            </div>
            <div class="a1ai-stats-grid">
                <div class="a1ai-stats-card">
                    <div class="a1ai-stats-title"><?php echo esc_html__('Total Messages', 'a1ai-chatbot'); ?></div>
                    <div class="a1ai-stats-number"><?php echo esc_html(number_format_i18n($totals['message_count'])); ?></div>
                </div>
                <div class="a1ai-stats-card">
                    <div class="a1ai-stats-title"><?php echo esc_html__('Total Conversations', 'a1ai-chatbot'); ?></div>
                    <div class="a1ai-stats-number"><?php echo esc_html(number_format_i18n($totals['conversation_count'])); ?></div>
                </div>
                <div class="a1ai-stats-card">
                    <div class="a1ai-stats-title"><?php echo esc_html__('Total Tokens Used', 'a1ai-chatbot'); ?></div>
                    <div class="a1ai-stats-number"><?php echo esc_html(number_format_i18n($totals['tokens_used'])); ?></div>
                </div>
                <div class="a1ai-stats-card">
                    <div class="a1ai-stats-title"><?php echo esc_html__('Avg Messages/Conv', 'a1ai-chatbot'); ?></div>
                    <div class="a1ai-stats-number">
                        <?php
                        $avg_messages = $totals['conversation_count'] > 0
                            ? round($totals['message_count'] / $totals['conversation_count'], 1)
                            : 0;
                        echo esc_html(number_format_i18n($avg_messages, 1));
                        ?>
                    </div>
                </div>
                <div class="a1ai-stats-card">
                    <div class="a1ai-stats-title"><?php echo esc_html__('Avg Tokens/Message', 'a1ai-chatbot'); ?></div>
                    <div class="a1ai-stats-number">
                        <?php
                        $avg_tokens = $totals['message_count'] > 0
                            ? round($totals['tokens_used'] / $totals['message_count'], 0)
                            : 0;
                        echo esc_html(number_format_i18n($avg_tokens));
                        ?>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="a1ai-card">
            <h3><?php echo esc_html__('Recent Activity', 'a1ai-chatbot'); ?></h3>
            <div style="width: 100%; height: 300px;">
                <canvas id="a1ai-analytics-chart"></canvas>
                <div id="a1ai-chart-fallback" style="display: none; text-align: center; padding: 50px 20px; color: #666;">
                    <p><?php echo esc_html__('Chart data is loading...', 'a1ai-chatbot'); ?></p>
                </div>
            </div>
        </div>
        
        <div class="a1ai-card">
            <h3><?php echo esc_html__('Quick Actions', 'a1ai-chatbot'); ?></h3>
            <ul class="a1ai-action-list">
                <li>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=a1ai-chatbots&action=add')); ?>">
                        <?php echo esc_html__('Create a new chatbot', 'a1ai-chatbot'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=a1ai-chatbots')); ?>">
                        <?php echo esc_html__('Manage existing chatbots', 'a1ai-chatbot'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=a1ai-settings')); ?>">
                        <?php echo esc_html__('Configure plugin settings', 'a1ai-chatbot'); ?>
                    </a>
                </li>
                <li>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=a1ai-settings#tab-upgrades')); ?>">
                        <?php echo esc_html__('Upgrades, Add-Ons & Services', 'a1ai-chatbot'); ?>
                    </a>
                </li>
            </ul>
        </div>
        
        <div class="a1ai-card">
            <h3><?php echo esc_html__('Getting Started', 'a1ai-chatbot'); ?></h3>
            <ol class="a1ai-getting-started">
                <li><?php echo esc_html__('Set up your OpenAI API key in the Settings page', 'a1ai-chatbot'); ?></li>
                <li><?php echo esc_html__('Create a new chatbot with your desired configuration', 'a1ai-chatbot'); ?></li>
                <li><?php echo esc_html__('Configure global chatbot settings if needed', 'a1ai-chatbot'); ?></li>
                <li><?php echo esc_html__('Test your chatbot on your website', 'a1ai-chatbot'); ?></li>
            </ol>
            <p>
                <a href="https://a1aidigital.com/ai-wordpress-plugin/setup/" target="_blank" class="button">
                    <?php echo esc_html__('View Documentation', 'a1ai-chatbot'); ?>
                </a>
            </p>
        </div>

        <?php if ($upgrade_active): ?>
        <div class="a1ai-card" style="grid-column: 1 / -1;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h3 style="margin: 0;"><?php echo esc_html__('Message Trends', 'a1ai-chatbot'); ?></h3>
                <div class="a1ai-date-range-controls">
                    <label for="a1ai-date-from" style="margin-right: 5px;"><?php echo esc_html__('From:', 'a1ai-chatbot'); ?></label>
                    <input type="date" id="a1ai-date-from" class="a1ai-date-input" value="<?php echo esc_attr(gmdate('Y-m-d', strtotime('-30 days'))); ?>" />
                    <label for="a1ai-date-to" style="margin: 0 5px 0 15px;"><?php echo esc_html__('To:', 'a1ai-chatbot'); ?></label>
                    <input type="date" id="a1ai-date-to" class="a1ai-date-input" value="<?php echo esc_attr(gmdate('Y-m-d')); ?>" />
                    <button type="button" id="a1ai-update-trends" class="button button-primary" style="margin-left: 10px;">
                        <?php echo esc_html__('Update', 'a1ai-chatbot'); ?>
                    </button>
                    <select id="a1ai-chart-period" class="a1ai-period-select" style="margin-left: 10px;">
                        <option value="day"><?php echo esc_html__('Daily', 'a1ai-chatbot'); ?></option>
                        <option value="week" selected><?php echo esc_html__('Weekly', 'a1ai-chatbot'); ?></option>
                        <option value="month"><?php echo esc_html__('Monthly', 'a1ai-chatbot'); ?></option>
                    </select>
                </div>
            </div>
            <div style="width: 100%; height: 400px;">
                <canvas id="a1ai-trends-chart"></canvas>
                <div id="a1ai-trends-fallback" style="display: none; text-align: center; padding: 50px 20px; color: #666;">
                    <p><?php echo esc_html__('Trends data is loading...', 'a1ai-chatbot'); ?></p>
                </div>
            </div>
        </div>
        <?php else: ?>
        <div class="a1ai-card" style="grid-column: 1 / -1;">
            <h3><?php echo esc_html__('Message Trends', 'a1ai-chatbot'); ?></h3>
            <div style="text-align: center; padding: 60px 20px; background: #f0f8ff; border: 2px dashed #0073aa; border-radius: 8px;">
                <div style="font-size: 48px; margin-bottom: 20px;">📊</div>
                <h4 style="margin: 0 0 15px 0; color: #0073aa;"><?php echo esc_html__('Premium Feature - Message Trends Analytics', 'a1ai-chatbot'); ?></h4>
                <p style="color: #666; margin-bottom: 20px;"><?php echo esc_html__('Unlock detailed message trends, advanced analytics, and data export capabilities with the premium upgrade.', 'a1ai-chatbot'); ?></p>
                <a href="<?php echo esc_url(admin_url('admin.php?page=a1ai-settings#tab-upgrades')); ?>" class="button button-primary" style="background: #0073aa;">
                    <?php echo esc_html__('Upgrade to Access Message Trends', 'a1ai-chatbot'); ?>
                </a>
            </div>
        </div>
        <?php endif; ?>

    </div>
</div> 

<style>
/* AI Assistant Styles */
.a1ai-assistant-card {
    grid-column: 1;
    grid-row: 1 / span 2;
    height: auto;
    min-height: 600px;
}

.a1ai-assistant-container {
    display: flex;
    flex-direction: column;
    height: 100%;
}

.a1ai-assistant-messages {
    flex: 1;
    max-height: 400px;
    overflow-y: auto;
    border: 1px solid #ddd;
    border-radius: 8px;
    padding: 15px;
    margin-bottom: 15px;
    background: #f9f9f9;
}

.a1ai-assistant-message {
    display: flex;
    margin-bottom: 15px;
    align-items: flex-start;
}

.a1ai-assistant-message:last-child {
    margin-bottom: 0;
}

.a1ai-assistant-user {
    flex-direction: row-reverse;
}

.a1ai-assistant-user .a1ai-assistant-avatar {
    margin-right: 0;
    margin-left: 10px;
}

.a1ai-assistant-user .a1ai-assistant-content {
    background: #0073aa;
    color: white;
    border-color: #005a87;
}

.a1ai-assistant-avatar {
    font-size: 24px;
    margin-right: 10px;
    flex-shrink: 0;
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #f8f9fa;
    border-radius: 6px;
    border: 1px solid #e9ecef;
}

.a1ai-assistant-avatar img {
    width: 24px;
    height: 24px;
    object-fit: contain;
    border-radius: 2px;
}

.a1ai-assistant-content {
    flex: 1;
    background: white;
    padding: 12px 15px;
    border-radius: 8px;
    border: 1px solid #e1e1e1;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

.a1ai-assistant-content p {
    margin: 0 0 10px 0;
    line-height: 1.5;
}

.a1ai-assistant-content p:last-child {
    margin-bottom: 0;
}

.a1ai-assistant-content h4 {
    margin: 0 0 15px 0;
    color: #0073aa;
    font-size: 16px;
}

.a1ai-assistant-content ul,
.a1ai-assistant-content ol {
    margin: 0 0 15px 0;
    padding-left: 20px;
}

.a1ai-assistant-content li {
    margin-bottom: 5px;
}

.a1ai-assistant-content strong {
    color: #0073aa;
}

/* Typing indicator styles */
#typing-indicator .a1ai-assistant-content {
    background: #f0f0f0;
    border-color: #ddd;
}

#typing-indicator .a1ai-assistant-content p {
    color: #666;
    font-style: italic;
}

.a1ai-contact-form input,
.a1ai-contact-form textarea {
    border: 1px solid #ddd;
    border-radius: 4px;
    font-family: inherit;
}

.a1ai-contact-form input:focus,
.a1ai-contact-form textarea:focus {
    border-color: #0073aa;
    outline: none;
    box-shadow: 0 0 0 1px #0073aa;
}

.a1ai-assistant-input {
    display: flex;
    gap: 10px;
    margin-bottom: 15px;
}

.a1ai-assistant-input input {
    flex: 1;
    padding: 8px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 14px;
}

.a1ai-assistant-quick-actions {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 10px;
}

.a1ai-assistant-quick-btn {
    padding: 8px 12px;
    background: #f0f0f0;
    border: 1px solid #ddd;
    border-radius: 4px;
    cursor: pointer;
    font-size: 12px;
    text-align: center;
    transition: all 0.2s ease;
}

.a1ai-assistant-quick-btn:hover {
    background: #e0e0e0;
    border-color: #999;
}

.a1ai-assistant-quick-btn[data-action="setup-openai"] {
    background: #0073aa;
    color: white;
    border-color: #005a87;
}

.a1ai-assistant-quick-btn[data-action="setup-openai"]:hover {
    background: #005a87;
}

.a1ai-assistant-quick-btn[data-action="management-services"] {
    background: #46b450;
    color: white;
    border-color: #389a43;
}

.a1ai-assistant-quick-btn[data-action="management-services"]:hover {
    background: #389a43;
}

/* Suggested Prompts Styles */
.a1ai-suggested-prompts {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
}

.a1ai-prompt-suggestion {
    padding: 6px 12px;
    background: #fff;
    border: 1px solid #0073aa;
    border-radius: 20px;
    cursor: pointer;
    font-size: 12px;
    text-align: left;
    transition: all 0.2s ease;
    color: #0073aa;
    white-space: nowrap;
}

.a1ai-prompt-suggestion:hover {
    background: #0073aa;
    color: #fff;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0, 115, 170, 0.2);
}

.a1ai-prompt-suggestion:active {
    transform: translateY(0);
    box-shadow: 0 1px 2px rgba(0, 115, 170, 0.2);
}

/* Dashboard Grid Layout Update */
.a1ai-dashboard-grid {
    display: grid;
    grid-template-columns: 400px 1fr 1fr;
    grid-template-rows: auto auto;
    gap: 20px;
    margin-top: 20px;
}

.a1ai-card {
    background: white;
    border: 1px solid #ccd0d4;
    border-radius: 8px;
    padding: 20px;
    box-shadow: 0 1px 3px rgba(0,0,0,0.1);
}

/* Responsive Design */
@media (max-width: 1200px) {
    .a1ai-dashboard-grid {
        grid-template-columns: 1fr 1fr;
        grid-template-rows: auto auto auto;
    }
    
    .a1ai-assistant-card {
        grid-column: 1 / span 2;
        grid-row: 1;
    }
}

@media (max-width: 768px) {
    .a1ai-dashboard-grid {
        grid-template-columns: 1fr;
        grid-template-rows: auto;
    }
    
    .a1ai-assistant-card {
        grid-column: 1;
        grid-row: 1;
    }
    
    .a1ai-assistant-quick-actions {
        grid-template-columns: 1fr;
    }
}
</style> 

<script>
jQuery(document).ready(function($) {
    // Define ajaxurl if not already defined
    if (typeof ajaxurl === 'undefined') {
        var ajaxurl = '<?php echo esc_url(admin_url('admin-ajax.php')); ?>';
    }
    
    // Logo variables for consistent avatar display
    const logoUrl = '<?php echo esc_url(plugins_url('assets/images/square-logo-tiny1.png', dirname(dirname(__FILE__)))); ?>';
    const logoExists = <?php echo wp_json_encode((bool) $logo_exists); ?>;
    const assistantLogoHtml = <?php
    $logo_url = plugins_url('assets/images/square-logo-tiny1.png', dirname(dirname(__FILE__)));
    $logo_exists = file_exists(plugin_dir_path(dirname(dirname(__FILE__))) . 'assets/images/square-logo-tiny1.png');
    $logo_html = $logo_exists
        ? '<img src="' . esc_url($logo_url) . '" alt="' . esc_attr__('A1AI Logo', 'a1ai-chatbot') . '" class="a1ai-logo-img" width="24" height="24" loading="lazy" decoding="async" />'
        : '<span class="a1ai-logo-fallback" style="font-size: 24px;">🤖</span>';
    echo wp_json_encode('<div class="a1ai-logo-container">' . $logo_html . '</div>');
    ?>;

    // Check if user has premium upgrade (for conditional messaging)
    const hasUpgrade = <?php echo wp_json_encode((bool) $upgrade_active); ?>;

    // AI Assistant functionality
    const assistantMessages = $('#a1ai-assistant-messages');
    const assistantInput = $('#a1ai-assistant-input');
    const assistantSend = $('#a1ai-assistant-send');
    const quickActionBtns = $('.a1ai-assistant-quick-btn');
    
    // AI Assistant knowledge base (enhanced for better sales)
    const aiKnowledge = {
        setupOpenAI: {
            title: '🚀 Quick Setup Guide - Get Your Chatbot Live in 10 Minutes',
            steps: [
                '1. Visit <a href="https://platform.openai.com" target="_blank">https://platform.openai.com</a> and create a free account',
                '2. Add a payment method (OpenAI typically costs $10-30/month for most businesses)',
                '3. Navigate to <strong>API Keys</strong> in your OpenAI dashboard',
                '4. Click <strong>"Create new secret key"</strong>',
                '5. Copy the API key (you\'ll only see it once!)',
                '6. Come back here → <a href="' + '<?php echo esc_url(admin_url('admin.php?page=a1ai-settings')); ?>' + '">A1AI Settings</a>',
                '7. Paste your API key and click <strong>Save Changes</strong>',
                '8. Create your first chatbot and test it!',
                '9. Add to your website using the global widget or shortcode'
            ],
            note: '💡 <strong>Cost Control Tip:</strong> Start with GPT-3.5 Turbo (cheaper) and 800 max tokens. You can always upgrade to GPT-4 later for better responses.'
        },
        premiumFeatures: {
            title: '⭐ Premium Features - See What You\'re Missing',
            intro: 'The free version is great for getting started, but Premium unlocks serious business growth tools. Here\'s what changes:',
            features: [
                '<strong>Smart Contact Forms</strong> - Capture 40-70% more leads with conversational forms (vs traditional forms)',
                '<strong>Review Management</strong> - Get 3-5x more 5-star reviews automatically (huge for local SEO)',
                '<strong>Content Awareness</strong> - Your chatbot actually KNOWS your products/services (85% fewer "I don\'t know" responses)',
                '<strong>Advanced Adjustments</strong> - Fix bad responses in 30 seconds instead of hours of prompt tweaking',
                '<strong>Advanced Analytics</strong> - See what customers REALLY ask about, find your #1 objection, boost conversions',
                '<strong>Voice Integration</strong> - Voice input/output for accessibility and mobile users',
                '<strong>Google Integration</strong> - Book appointments, sync to Sheets, automate workflows'
            ],
            pricing: '<strong>Just $199/year for single site</strong> (that\'s $0.54/day - less than a coffee!)',
            roi: '📈 <strong>ROI Reality Check:</strong> If Premium generates just ONE extra lead per month, and your customer LTV is over $200, you\'re profitable. Most clients see 3-10 qualified leads monthly.',
            upgrade: 'Ready to upgrade? Visit <a href="' + '<?php echo esc_url(admin_url('admin.php?page=a1ai-settings#tab-upgrades')); ?>' + '">Settings → Upgrades</a> or call us for guided setup.'
        },
        managementServices: {
            title: '💼 Done-For-You Chatbot Management',
            intro: 'Let\'s be honest: A great chatbot takes 10-15 hours to set up properly, then 3-5 hours weekly to optimize. Do you have that time?',
            benefits: [
                '<strong>Zero Effort, Maximum Results</strong> - We handle everything from setup to optimization',
                '<strong>Expert Prompt Engineering</strong> - Our team has 1000+ hours of experience across 50+ industries',
                '<strong>Weekly Optimization</strong> - Your chatbot gets smarter every week without you lifting a finger',
                '<strong>ROI Tracking</strong> - Monthly reports showing exactly how many leads/conversions your chatbot generated',
                '<strong>24/7 Monitoring</strong> - We catch and fix issues before they cost you leads',
                '<strong>Strategic Consulting</strong> - We analyze your data and recommend what to improve for max ROI'
            ],
            pricing: [
                '<strong>Starter:</strong> $497/mo - Perfect for testing (1 chatbot, monthly optimization)',
                '<strong>Growth:</strong> $997/mo - Most Popular (up to 3 chatbots, bi-weekly optimization, phone support)',
                '<strong>Enterprise:</strong> $2,497/mo - For serious scale (unlimited chatbots, weekly optimization, dedicated manager)'
            ],
            roi_example: '💰 <strong>Real ROI Example:</strong> Restaurant client with Growth plan ($997/mo) averages 12 reservation requests/day via chatbot. At $45 average ticket = $16,200/month in revenue. That\'s 16x ROI.',
            question: '<strong>Quick Question:</strong> What\'s your time worth? If it\'s over $100/hour, Managed Services actually SAVES you money while delivering better results.'
        },
        helpSupport: {
            title: '🔧 How Can I Help You Today?',
            intro: 'I can help with anything from quick fixes to strategic advice:',
            options: [
                '<strong>Technical Issues:</strong> Chatbot not showing, API errors, plugin conflicts',
                '<strong>Optimization:</strong> Improve response quality, reduce bad answers, boost conversions',
                '<strong>Setup Questions:</strong> Shortcodes, widgets, mobile display, GDPR compliance',
                '<strong>Feature Explanations:</strong> How to use adjustments, prompts, conversation history',
                '<strong>Performance Analysis:</strong> Review your stats and suggest improvements',
                '<strong>Strategic Advice:</strong> Should you upgrade? Go managed? What\'s the best path?'
            ],
            cta: 'Just type your question or describe the issue - I\'ll guide you through it step by step!'
        }
    };
    
    // Function to add a message to the chat
    function addMessage(content, isUser = false) {
        const messageClass = isUser ? 'a1ai-assistant-user' : 'a1ai-assistant-bot';

        // Create avatar based on logo availability
        let avatar;
        if (isUser) {
            avatar = '👤';
        } else {
            avatar = assistantLogoHtml;
        }
        
        const messageHtml = `
            <div class="a1ai-assistant-message ${messageClass}">
                <div class="a1ai-assistant-avatar">${avatar}</div>
                <div class="a1ai-assistant-content">
                    ${content}
                </div>
            </div>
        `;
        
        assistantMessages.append(messageHtml);
        assistantMessages.scrollTop(assistantMessages[0].scrollHeight);
    }
    
    // Function to handle quick action buttons
    function handleQuickAction(action) {
        let response = '';

        switch(action) {
            case 'setup-openai':
                response = `
                    <h4>${aiKnowledge.setupOpenAI.title}</h4>
                    <ol style="line-height: 1.8;">
                        ${aiKnowledge.setupOpenAI.steps.map(step => `<li>${step}</li>`).join('')}
                    </ol>
                    <p>${aiKnowledge.setupOpenAI.note}</p>

                    <div style="background: #fff9e6; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0;">
                        <p style="margin: 0;"><strong>⏱️ Don't Have Time?</strong> We offer professional setup where we handle everything for you - from OpenAI account to fully optimized chatbot. Email <a href="mailto:contact@a1aidigital.com">contact@a1aidigital.com</a> or call <a href="tel:801-893-1686">801-893-1686</a>.</p>
                    </div>

                    <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid #ddd;">
                        <p style="margin: 0 0 10px 0; font-size: 13px; color: #666;"><strong>💬 Quick Questions (click to ask):</strong></p>
                        <div class="a1ai-suggested-prompts">
                            <button class="a1ai-prompt-suggestion" data-prompt="How do I add a payment method to OpenAI?">💳 How do I add a payment method to OpenAI?</button>
                            <button class="a1ai-prompt-suggestion" data-prompt="What are the typical monthly costs for OpenAI?">💰 What are typical monthly costs?</button>
                            <button class="a1ai-prompt-suggestion" data-prompt="Can you help me create my first chatbot after setup?">🤖 Help me create my first chatbot</button>
                            <button class="a1ai-prompt-suggestion" data-prompt="Tell me about done-for-you professional setup">⚡ Tell me about professional setup</button>
                        </div>
                    </div>
                `;
                break;

            case 'premium-features':
                if (hasUpgrade) {
                    // Premium user - help them optimize their features
                    response = `
                        <h4>⭐ Maximize Your Premium Features</h4>
                        <p><strong>Great news! You already have ALL premium features unlocked:</strong></p>
                        <ul style="line-height: 1.8;">
                            <li>✓ <strong>Smart Contact Forms</strong> - Are you using conversational forms to capture more leads?</li>
                            <li>✓ <strong>Review Management</strong> - Have you set up automated review requests?</li>
                            <li>✓ <strong>Content Awareness</strong> - Is your chatbot trained on your website content?</li>
                            <li>✓ <strong>Advanced Adjustments</strong> - Are you fixing bad responses quickly?</li>
                            <li>✓ <strong>Advanced Analytics</strong> - Are you tracking what visitors ask about?</li>
                            <li>✓ <strong>Voice & Google Integration</strong> - Set up for maximum convenience?</li>
                        </ul>

                        <div style="background: #fff9e6; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0;">
                            <p style="margin: 0;"><strong>⚡ Reality Check:</strong> Most businesses use only 30-40% of their premium features effectively. Are you getting your full ROI?</p>
                        </div>

                        <p><strong>Need help setting these up or optimizing them?</strong> I can guide you, or we can introduce you to our Managed Services team who will handle everything.</p>

                        <div style="background: #e8f4f8; border: 2px solid #0288d1; border-radius: 8px; padding: 15px; margin: 20px 0;">
                            <h4 style="margin: 0 0 10px 0; color: #01579b;">💼 Managed Services - The Upgrade to Your Upgrade</h4>
                            <p style="margin: 0 0 10px 0; color: #01579b;">You invested in Premium features. Now let experts make them work 10x harder:</p>
                            <ul style="margin: 10px 0; color: #01579b;">
                                <li><strong>Weekly optimization</strong> - We fine-tune everything based on your data</li>
                                <li><strong>ROI tracking</strong> - See exactly how many leads/conversions you're getting</li>
                                <li><strong>Zero effort</strong> - We handle all the technical work</li>
                                <li><strong>Guaranteed results</strong> - Or we keep working until you get them</li>
                            </ul>
                            <p style="margin: 0; color: #01579b;"><strong>Starting at $997/mo (most popular plan)</strong></p>
                        </div>

                        <div style="background: #e8f5e8; border: 1px solid #c3e6c3; border-radius: 8px; padding: 15px; margin-top: 20px;">
                            <h4 style="margin: 0 0 10px 0; color: #2d5a2d;">📞 Ready to 10x Your Results?</h4>
                            <p style="margin: 0 0 8px 0; color: #2d5a2d;"><strong>Email:</strong> <a href="mailto:contact@a1aidigital.com?subject=Managed Services for Premium User" style="color: #2d5a2d;">contact@a1aidigital.com</a></p>
                            <p style="margin: 0; color: #2d5a2d;"><strong>Phone:</strong> <a href="tel:801-893-1686" style="color: #2d5a2d;">801-893-1686</a> (Mon-Fri 9am-6pm MT)</p>
                            <p style="margin: 10px 0 0 0; font-size: 13px; color: #2d5a2d;"><em>Ask about our Premium User discount on Managed Services!</em></p>
                        </div>

                        <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid #ddd;">
                            <p style="margin: 0 0 10px 0; font-size: 13px; color: #666;"><strong>💬 Quick Questions (click to ask):</strong></p>
                            <div class="a1ai-suggested-prompts">
                                <button class="a1ai-prompt-suggestion" data-prompt="How can I optimize my Smart Contact Forms for more conversions?">📝 Optimize Contact Forms</button>
                                <button class="a1ai-prompt-suggestion" data-prompt="Walk me through setting up Review Management">⭐ Setup Review Management</button>
                                <button class="a1ai-prompt-suggestion" data-prompt="How does Content Awareness actually work?">🧠 Explain Content Awareness</button>
                                <button class="a1ai-prompt-suggestion" data-prompt="What's the difference between Growth and Enterprise Managed Services?">💼 Compare Managed Plans</button>
                            </div>
                        </div>
                    `;
                } else {
                    // Free user - sell them premium
                    response = `
                        <h4>${aiKnowledge.premiumFeatures.title}</h4>
                        <p>${aiKnowledge.premiumFeatures.intro}</p>
                        <ul style="line-height: 1.8;">
                            ${aiKnowledge.premiumFeatures.features.map(feature => `<li>${feature}</li>`).join('')}
                        </ul>

                        <div style="background: #e3f2fd; border: 2px solid #2196f3; border-radius: 8px; padding: 15px; margin: 20px 0;">
                            <p style="margin: 0 0 10px 0;">${aiKnowledge.premiumFeatures.pricing}</p>
                            <p style="margin: 0;">${aiKnowledge.premiumFeatures.roi}</p>
                        </div>

                        <p>${aiKnowledge.premiumFeatures.upgrade}</p>

                        <div style="background: #f3e5f5; border-left: 4px solid #9c27b0; padding: 15px; margin-top: 20px;">
                            <p style="margin: 0 0 10px 0;"><strong>💼 Want Zero Effort Instead?</strong></p>
                            <p style="margin: 0;">Our Managed Services include Premium features PLUS complete setup, ongoing optimization, and guaranteed results. Starting at $497/mo.</p>
                            <p style="margin: 10px 0 0 0;"><a href="mailto:contact@a1aidigital.com?subject=Managed Services Inquiry">Learn about Managed Services →</a></p>
                        </div>

                        <div style="background: #e8f5e8; border: 1px solid #c3e6c3; border-radius: 8px; padding: 15px; margin-top: 20px;">
                            <h4 style="margin: 0 0 10px 0; color: #2d5a2d;">📞 Questions? Let's Chat</h4>
                            <p style="margin: 0 0 8px 0; color: #2d5a2d;"><strong>Email:</strong> <a href="mailto:contact@a1aidigital.com" style="color: #2d5a2d;">contact@a1aidigital.com</a></p>
                            <p style="margin: 0; color: #2d5a2d;"><strong>Phone:</strong> <a href="tel:801-893-1686" style="color: #2d5a2d;">801-893-1686</a> (Mon-Fri 9am-6pm MT)</p>
                        </div>

                        <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid #ddd;">
                            <p style="margin: 0 0 10px 0; font-size: 13px; color: #666;"><strong>💬 Quick Questions (click to ask):</strong></p>
                            <div class="a1ai-suggested-prompts">
                                <button class="a1ai-prompt-suggestion" data-prompt="Which premium feature should I prioritize first?">🎯 Which feature should I prioritize?</button>
                                <button class="a1ai-prompt-suggestion" data-prompt="How do I calculate my ROI from Premium?">📊 How do I calculate ROI?</button>
                                <button class="a1ai-prompt-suggestion" data-prompt="Show me premium success stories from my industry">💼 Show me success stories</button>
                                <button class="a1ai-prompt-suggestion" data-prompt="What's included in the 14-day money-back guarantee?">✅ Tell me about the guarantee</button>
                            </div>
                        </div>
                    `;
                }
                break;

            case 'management-services':
                if (hasUpgrade) {
                    // Premium user - emphasize optimization and results
                    response = `
                        <h4>💼 Managed Services - Your Next Level</h4>
                        <p style="font-size: 15px; color: #555;"><strong>You've made a smart investment in Premium.</strong> Now multiply your results with expert management.</p>

                        <div style="background: #e8f4f8; border: 2px solid #0288d1; border-radius: 8px; padding: 15px; margin: 20px 0;">
                            <h4 style="margin: 0 0 10px 0; color: #01579b;">⚡ The Premium User's Dilemma:</h4>
                            <p style="margin: 0; color: #01579b;">You have all the tools... but are you really maximizing them? Most Premium users admit they're using only 30-40% of their features effectively.</p>
                        </div>

                        <p><strong>What changes with Managed Services:</strong></p>
                        <ul style="line-height: 1.8;">
                            <li><strong>Weekly optimization</strong> - We analyze your data and make your features work harder every week</li>
                            <li><strong>Feature utilization</strong> - We ensure you're getting full value from Contact Forms, Review Management, Content Awareness, etc.</li>
                            <li><strong>ROI tracking</strong> - Monthly reports showing exactly how many leads/conversions your chatbot generates</li>
                            <li><strong>Proactive improvements</strong> - We catch and fix issues before they cost you leads</li>
                            <li><strong>Strategic consulting</strong> - Quarterly reviews to align your chatbot with business goals</li>
                            <li><strong>Zero time investment</strong> - You focus on your business, we handle everything</li>
                        </ul>

                        <p><strong>Premium User Pricing:</strong></p>
                        <ul style="line-height: 1.8;">
                            <li><strong>Growth:</strong> $997/mo - Most Popular (bi-weekly optimization, phone support)</li>
                            <li><strong>Enterprise:</strong> $2,497/mo - For scale (weekly optimization, dedicated manager)</li>
                        </ul>

                        <div style="background: #e8f4f8; border: 2px solid #0288d1; border-radius: 8px; padding: 15px; margin: 20px 0;">
                            <p style="margin: 0;">${aiKnowledge.managementServices.roi_example}</p>
                        </div>

                        <div style="background: #fff3cd; border-left: 4px solid #ff9800; padding: 15px; margin: 20px 0;">
                            <p style="margin: 0;"><strong>You're already spending $199/year on Premium.</strong> For $997/mo, you get expert optimization that typically delivers 5-10x better results. What's your time worth?</p>
                        </div>

                        <div style="background: #e8f5e8; border: 1px solid #c3e6c3; border-radius: 8px; padding: 15px; margin-bottom: 20px;">
                            <h4 style="margin: 0 0 10px 0; color: #2d5a2d;">📞 Free ROI Analysis for Premium Users</h4>
                            <p style="margin: 0 0 8px 0; color: #2d5a2d;">We'll review your current setup and show exactly how much MORE you could be getting from your Premium investment.</p>
                            <p style="margin: 0 0 8px 0; color: #2d5a2d;"><strong>Email:</strong> <a href="mailto:contact@a1aidigital.com?subject=Premium User ROI Analysis" style="color: #2d5a2d;">contact@a1aidigital.com</a></p>
                            <p style="margin: 0; color: #2d5a2d;"><strong>Phone:</strong> <a href="tel:801-893-1686" style="color: #2d5a2d;">801-893-1686</a></p>
                            <p style="margin: 10px 0 0 0; font-size: 13px; color: #2d5a2d;"><em>Or use the form below. Mention you're a Premium user for priority response!</em></p>
                        </div>

                        <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid #ddd;">
                            <p style="margin: 0 0 10px 0; font-size: 13px; color: #666;"><strong>💬 Quick Questions (click to ask):</strong></p>
                            <div class="a1ai-suggested-prompts">
                                <button class="a1ai-prompt-suggestion" data-prompt="What results can I expect from Managed Services?">📈 Expected results</button>
                                <button class="a1ai-prompt-suggestion" data-prompt="How much time will Managed Services save me per week?">⏱️ Time savings</button>
                                <button class="a1ai-prompt-suggestion" data-prompt="Can you share a success story similar to my business?">💼 Success stories</button>
                                <button class="a1ai-prompt-suggestion" data-prompt="What's the difference between Starter and Growth plans?">🎯 Compare plans</button>
                            </div>
                        </div>

                        <p><strong>Request Your Free ROI Analysis:</strong></p>
                        <div class="a1ai-contact-form">
                            <input type="text" id="contact-name" placeholder="Your Name *" style="width: 100%; margin-bottom: 10px; padding: 8px;">
                            <input type="email" id="contact-email" placeholder="Your Email *" style="width: 100%; margin-bottom: 10px; padding: 8px;">
                            <input type="tel" id="contact-phone" placeholder="Your Phone *" style="width: 100%; margin-bottom: 10px; padding: 8px;">
                            <textarea id="contact-message" placeholder="Tell us your current challenges and goals..." style="width: 100%; height: 80px; margin-bottom: 10px; padding: 8px;"></textarea>
                            <input type="hidden" id="contact-user-type" value="premium">
                            <button type="button" id="submit-contact" class="button button-primary" style="width: 100%; padding: 12px; font-size: 16px;">📞 Request Free ROI Analysis</button>
                        </div>
                    `;
                } else {
                    // Free user - emphasize that managed includes premium
                    response = `
                        <h4>${aiKnowledge.managementServices.title}</h4>
                        <p style="font-size: 15px; color: #555;">${aiKnowledge.managementServices.intro}</p>

                        <div style="background: #e3f2fd; border: 2px solid #2196f3; border-radius: 8px; padding: 15px; margin: 20px 0;">
                            <p style="margin: 0;"><strong>💎 Bonus:</strong> Managed Services includes ALL Premium features ($199/year value) PLUS expert management. You get everything.</p>
                        </div>

                        <p><strong>Here's what you get with Managed Services:</strong></p>
                        <ul style="line-height: 1.8;">
                            ${aiKnowledge.managementServices.benefits.map(benefit => `<li>${benefit}</li>`).join('')}
                        </ul>

                        <p><strong>Pricing Options:</strong></p>
                        <ul style="line-height: 1.8;">
                            ${aiKnowledge.managementServices.pricing.map(price => `<li>${price}</li>`).join('')}
                        </ul>

                        <div style="background: #e8f4f8; border: 2px solid #0288d1; border-radius: 8px; padding: 15px; margin: 20px 0;">
                            <p style="margin: 0;">${aiKnowledge.managementServices.roi_example}</p>
                        </div>

                        <div style="background: #fff3cd; border-left: 4px solid #ff9800; padding: 15px; margin: 20px 0;">
                            <p style="margin: 0;">${aiKnowledge.managementServices.question}</p>
                        </div>

                        <div style="background: #e8f5e8; border: 1px solid #c3e6c3; border-radius: 8px; padding: 15px; margin-bottom: 20px;">
                            <h4 style="margin: 0 0 10px 0; color: #2d5a2d;">📞 Book a Free Strategy Call</h4>
                            <p style="margin: 0 0 8px 0; color: #2d5a2d;">We'll analyze your business and show you the exact ROI you can expect.</p>
                            <p style="margin: 0 0 8px 0; color: #2d5a2d;"><strong>Email:</strong> <a href="mailto:contact@a1aidigital.com?subject=Strategy Call Request" style="color: #2d5a2d;">contact@a1aidigital.com</a> with "Strategy Call" in subject</p>
                            <p style="margin: 0; color: #2d5a2d;"><strong>Phone:</strong> <a href="tel:801-893-1686" style="color: #2d5a2d;">801-893-1686</a></p>
                            <p style="margin: 10px 0 0 0; font-size: 13px; color: #2d5a2d;"><em>Or use the form below to request a callback.</em></p>
                        </div>

                        <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid #ddd;">
                            <p style="margin: 0 0 10px 0; font-size: 13px; color: #666;"><strong>💬 Quick Questions (click to ask):</strong></p>
                            <div class="a1ai-suggested-prompts">
                                <button class="a1ai-prompt-suggestion" data-prompt="Do Managed Services include Premium features?">✨ What's included?</button>
                                <button class="a1ai-prompt-suggestion" data-prompt="How quickly will I see results with Managed Services?">⚡ Timeline to results</button>
                                <button class="a1ai-prompt-suggestion" data-prompt="What industries do you have the most success with?">🏆 Best fit industries</button>
                                <button class="a1ai-prompt-suggestion" data-prompt="Can I upgrade from Starter to Growth plan later?">📈 Plan flexibility</button>
                            </div>
                        </div>

                        <p><strong>Request a Callback:</strong></p>
                        <div class="a1ai-contact-form">
                            <input type="text" id="contact-name" placeholder="Your Name *" style="width: 100%; margin-bottom: 10px; padding: 8px;">
                            <input type="email" id="contact-email" placeholder="Your Email *" style="width: 100%; margin-bottom: 10px; padding: 8px;">
                            <input type="tel" id="contact-phone" placeholder="Your Phone *" style="width: 100%; margin-bottom: 10px; padding: 8px;">
                            <textarea id="contact-message" placeholder="Tell us about your business and goals (optional)..." style="width: 100%; height: 80px; margin-bottom: 10px; padding: 8px;"></textarea>
                            <button type="button" id="submit-contact" class="button button-primary" style="width: 100%; padding: 12px; font-size: 16px;">📞 Request Strategy Call</button>
                        </div>
                    `;
                }
                break;

            case 'help-support':
                response = `
                    <h4>${aiKnowledge.helpSupport.title}</h4>
                    <p>${aiKnowledge.helpSupport.intro}</p>
                    <ul style="line-height: 1.8;">
                        ${aiKnowledge.helpSupport.options.map(option => `<li>${option}</li>`).join('')}
                    </ul>
                    <p>${aiKnowledge.helpSupport.cta}</p>

                    <div style="background: #fff9e6; border-left: 4px solid #ffc107; padding: 15px; margin: 20px 0;">
                        <p style="margin: 0;"><strong>💡 Pro Tip:</strong> If you're spending more than 2 hours/week managing your chatbot, our Managed Services will actually SAVE you time and money while delivering better results.</p>
                    </div>

                    <div style="background: #e8f5e8; border: 1px solid #c3e6c3; border-radius: 8px; padding: 15px; margin-top: 20px;">
                        <h4 style="margin: 0 0 10px 0; color: #2d5a2d;">📞 Need Direct Support?</h4>
                        <p style="margin: 0 0 8px 0; color: #2d5a2d;"><strong>Email:</strong> <a href="mailto:contact@a1aidigital.com" style="color: #2d5a2d;">contact@a1aidigital.com</a></p>
                        <p style="margin: 0; color: #2d5a2d;"><strong>Phone:</strong> <a href="tel:801-893-1686" style="color: #2d5a2d;">801-893-1686</a> (Mon-Fri 9am-6pm MT)</p>
                        <p style="margin: 10px 0 0 0; font-size: 13px; color: #2d5a2d;"><em>We typically respond within 4 hours on business days.</em></p>
                    </div>

                    <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid #ddd;">
                        <p style="margin: 0 0 10px 0; font-size: 13px; color: #666;"><strong>💬 Common Issues (click to learn more):</strong></p>
                        <div class="a1ai-suggested-prompts">
                            <button class="a1ai-prompt-suggestion" data-prompt="My chatbot isn't showing on my website">🚫 Chatbot not showing</button>
                            <button class="a1ai-prompt-suggestion" data-prompt="I'm getting OpenAI API errors">⚠️ API errors</button>
                            <button class="a1ai-prompt-suggestion" data-prompt="How do I improve my chatbot's response quality?">✨ Improve responses</button>
                            <button class="a1ai-prompt-suggestion" data-prompt="My chatbot gives wrong or irrelevant answers">🎯 Fix bad answers</button>
                        </div>
                    </div>
                `;
                break;
        }

        if (response) {
            addMessage(response);
        }
    }
    
    // Handle quick action button clicks
    quickActionBtns.on('click', function() {
        const action = $(this).data('action');
        handleQuickAction(action);
    });
    
    // Handle send button click
    assistantSend.on('click', function() {
        const message = assistantInput.val().trim();
        if (message) {
            addMessage(message, true);
            assistantInput.val('');
            
            // Show typing indicator
            const typingIndicator = `
                <div class="a1ai-assistant-message a1ai-assistant-bot" id="typing-indicator">
                    <div class="a1ai-assistant-avatar">
                        ${assistantLogoHtml}
                    </div>
                    <div class="a1ai-assistant-content">
                        <p>Typing...</p>
                    </div>
                </div>
            `;
            assistantMessages.append(typingIndicator);
            assistantMessages.scrollTop(assistantMessages[0].scrollHeight);
            
            // Send message to OpenAI via existing system
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'a1ai_admin_action',
                    action_type: 'assistant_chat',
                    nonce: a1aichAdmin ? a1aichAdmin.nonce : '',
                    message: message,
                    conversation_id: getConversationId()
                },
                success: function(response) {
                    // Remove typing indicator
                    $('#typing-indicator').remove();
                    
                    if (response.success) {
                        addMessage(response.data.response);
                    } else {
                        addMessage('<p style="color: red;">Error: ' + (response.data ? response.data.message : 'Failed to get response') + '</p>');
                    }
                },
                error: function() {
                    // Remove typing indicator
                    $('#typing-indicator').remove();
                    addMessage('<p style="color: red;">Error: Failed to connect to AI service. Please try again.</p>');
                }
            });
        }
    });
    
    // Function to get or create conversation ID for the assistant
    function getConversationId() {
        let conversationId = sessionStorage.getItem('a1ai_assistant_conversation_id');
        if (!conversationId) {
            conversationId = 'assistant_' + Date.now();
            sessionStorage.setItem('a1ai_assistant_conversation_id', conversationId);
        }
        return conversationId;
    }
    
    // Handle Enter key in input
    assistantInput.on('keypress', function(e) {
        if (e.which === 13) {
            assistantSend.click();
        }
    });

    // Handle suggested prompt clicks (using event delegation)
    $(document).on('click', '.a1ai-prompt-suggestion', function() {
        const prompt = $(this).data('prompt');
        if (prompt) {
            // Set the input value and trigger send
            assistantInput.val(prompt);
            assistantSend.click();
        }
    });
    
    // Handle contact form submission
    $(document).on('click', '#submit-contact', function() {
        const name = $('#contact-name').val().trim();
        const email = $('#contact-email').val().trim();
        const phone = $('#contact-phone').val().trim();
        const message = $('#contact-message').val().trim();
        
        if (!name || !email || !phone) {
            addMessage('<p style="color: red;">Please fill in all required fields (Name, Email, Phone).</p>');
            return;
        }
        
        // Submit via AJAX
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'a1ai_admin_action',
                action_type: 'submit_contact_request',
                nonce: a1aichAdmin ? a1aichAdmin.nonce : '',
                name: name,
                email: email,
                phone: phone,
                message: message,
                conversation_id: getConversationId()
            },
            success: function(response) {
                if (response.success) {
                    let successMessage = `
                        <p><strong>Thank you for your interest!</strong></p>
                        <p>I've received your contact request. A1AI will reach out to you within 24 hours to discuss your needs.</p>
                        <p>In the meantime, feel free to explore the plugin or ask me any questions!</p>
                        <div style="background: #e8f5e8; border: 1px solid #c3e6c3; border-radius: 8px; padding: 15px; margin-top: 15px;">
                            <h4 style="margin: 0 0 10px 0; color: #2d5a2d;">📞 Need Immediate Help?</h4>
                            <p style="margin: 0 0 8px 0; color: #2d5a2d;"><strong>Email:</strong> <a href="mailto:contact@a1aidigital.com" style="color: #2d5a2d; text-decoration: underline;">contact@a1aidigital.com</a></p>
                            <p style="margin: 0; color: #2d5a2d;"><strong>Phone:</strong> <a href="tel:801-893-1686" style="color: #2d5a2d; text-decoration: underline;">801-893-1686</a></p>
                            <p style="margin: 10px 0 0 0; font-size: 13px; color: #2d5a2d;"><em>Feel free to contact us directly if you need immediate assistance!</em></p>
                        </div>
                    `;
                    
                    // Add note if email delivery failed but request was saved
                    if (response.data && response.data.note) {
                        successMessage += `<p><em>Note: ${response.data.note}</em></p>`;
                        
                        // Add alternative contact information if email failed
                        if (response.data.alternative_contact) {
                            successMessage += `
                                <div style="background: #fff3cd; border: 1px solid #ffeaa7; border-radius: 8px; padding: 15px; margin-top: 15px;">
                                    <h4 style="margin: 0 0 10px 0; color: #856404;">📧 Alternative Contact Methods</h4>
                                    <p style="margin: 0 0 8px 0; color: #856404;"><strong>Email:</strong> <a href="mailto:${response.data.alternative_contact.email}" style="color: #856404; text-decoration: underline;">${response.data.alternative_contact.email}</a></p>
                                    <p style="margin: 0; color: #856404;"><strong>Phone:</strong> <a href="tel:${response.data.alternative_contact.phone}" style="color: #856404; text-decoration: underline;">${response.data.alternative_contact.phone}</a></p>
                                    <p style="margin: 10px 0 0 0; font-size: 13px; color: #856404;"><em>Please use these contact methods if you need immediate assistance or don't hear from us within 24 hours.</em></p>
                                </div>
                            `;
                        }
                    }
                    
                    addMessage(successMessage);
                    
                    // Clear the form
                    $('#contact-name, #contact-email, #contact-phone, #contact-message').val('');
                } else {
                    addMessage('<p style="color: red;">Error: ' + (response.data ? response.data.message : 'Failed to submit request') + '</p>');
                }
            },
            error: function(xhr, status, error) {
                console.error('Contact form submission error:', {xhr: xhr, status: status, error: error});
                addMessage('<p style="color: red;">Error: Failed to submit contact request. Status: ' + status + '. Please try again.</p>');
            }
        });
    });

    // Export functionality
    let exportData = null;

    // Fetch full analytics data for export
    function fetchExportData() {
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'a1ai_admin_action',
                action_type: 'get_export_data',
                nonce: a1aichAdmin ? a1aichAdmin.nonce : ''
            },
            success: function(response) {
                if (response.success) {
                    exportData = response.data;
                }
            }
        });
    }

    // Fetch export data on page load
    fetchExportData();

    // Export to CSV
    $('#a1ai-export-csv').on('click', function() {
        if (!exportData) {
            alert('Export data is still loading. Please try again in a moment.');
            return;
        }

        // Create CSV content
        let csv = 'Date,Messages,Conversations,Tokens Used\n';
        if (exportData.daily_stats) {
            exportData.daily_stats.forEach(function(row) {
                csv += `${row.date},${row.message_count},${row.conversation_count},${row.tokens_used}\n`;
            });
        }

        // Create download
        const blob = new Blob([csv], { type: 'text/csv' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = 'a1ai-analytics-' + new Date().toISOString().split('T')[0] + '.csv';
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
    });

    // Export to JSON
    $('#a1ai-export-json').on('click', function() {
        if (!exportData) {
            alert('Export data is still loading. Please try again in a moment.');
            return;
        }

        // Create JSON download
        const blob = new Blob([JSON.stringify(exportData, null, 2)], { type: 'application/json' });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = 'a1ai-analytics-' + new Date().toISOString().split('T')[0] + '.json';
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
    });

    // Message Trends Chart with date range
    let trendsChart = null;

    function loadTrendsChart() {
        const dateFrom = $('#a1ai-date-from').val();
        const dateTo = $('#a1ai-date-to').val();
        const period = $('#a1ai-chart-period').val();

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'a1ai_admin_action',
                action_type: 'get_trends_data',
                nonce: a1aichAdmin ? a1aichAdmin.nonce : '',
                date_from: dateFrom,
                date_to: dateTo,
                period: period
            },
            success: function(response) {
                if (response.success && response.data) {
                    const ctx = document.getElementById('a1ai-trends-chart');
                    if (ctx) {
                        // Destroy existing chart if it exists
                        if (trendsChart) {
                            trendsChart.destroy();
                        }

                        trendsChart = new Chart(ctx, {
                            type: 'line',
                            data: {
                                labels: response.data.labels || [],
                                datasets: [
                                    {
                                        label: 'Messages',
                                        data: response.data.messages || [],
                                        borderColor: 'rgb(75, 192, 192)',
                                        backgroundColor: 'rgba(75, 192, 192, 0.1)',
                                        tension: 0.3,
                                        fill: true
                                    },
                                    {
                                        label: 'Conversations',
                                        data: response.data.conversations || [],
                                        borderColor: 'rgb(255, 99, 132)',
                                        backgroundColor: 'rgba(255, 99, 132, 0.1)',
                                        tension: 0.3,
                                        fill: true
                                    },
                                    {
                                        label: 'Tokens (÷100)',
                                        data: response.data.tokens ? response.data.tokens.map(t => t / 100) : [],
                                        borderColor: 'rgb(153, 102, 255)',
                                        backgroundColor: 'rgba(153, 102, 255, 0.1)',
                                        tension: 0.3,
                                        fill: true
                                    }
                                ]
                            },
                            options: {
                                responsive: true,
                                maintainAspectRatio: false,
                                plugins: {
                                    legend: {
                                        position: 'top',
                                    },
                                    title: {
                                        display: false
                                    }
                                },
                                scales: {
                                    y: {
                                        beginAtZero: true
                                    }
                                }
                            }
                        });
                    }
                } else {
                    $('#a1ai-trends-fallback').show();
                }
            },
            error: function() {
                $('#a1ai-trends-fallback').show();
            }
        });
    }

    // Load trends chart on page load
    if (typeof Chart !== 'undefined') {
        loadTrendsChart();
    }

    // Update trends chart when button is clicked
    $('#a1ai-update-trends').on('click', function() {
        loadTrendsChart();
    });

    // Update trends chart when period changes
    $('#a1ai-chart-period').on('change', function() {
        loadTrendsChart();
    });

});
</script> 
