<?php
/**
 * Admin conversations template
 *
 * @link       https://a1aidigital.com
 * @since      1.0.0
 *
 * @package    A1AI
 * @subpackage A1AI/admin/partials
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Get recent conversations
$conversations = $data_manager->get_recent_conversations(50); // Get last 50 conversations
?>

    <h2><?php echo esc_html__('Recent Conversations', 'a1ai-chatbot'); ?></h2>
    
    <div class="a1ai-conversations-container">
        <div class="a1ai-conversations-table">
            <?php if (empty($conversations)) : ?>
                <div class="a1ai-empty-state">
                    <p><?php echo esc_html__('No conversations found.', 'a1ai-chatbot'); ?></p>
                </div>
            <?php else : ?>
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th><?php echo esc_html__('Chatbot', 'a1ai-chatbot'); ?></th>
                            <th><?php echo esc_html__('User', 'a1ai-chatbot'); ?></th>
                            <th><?php echo esc_html__('Session ID', 'a1ai-chatbot'); ?></th>
                            <th><?php echo esc_html__('Messages', 'a1ai-chatbot'); ?></th>
                            <th><?php echo esc_html__('Tokens Used', 'a1ai-chatbot'); ?></th>
                            <th><?php echo esc_html__('Started', 'a1ai-chatbot'); ?></th>
                            <th><?php echo esc_html__('Actions', 'a1ai-chatbot'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($conversations as $conversation) : 
                            // Get chatbot info
                            $chatbot = $data_manager->get_chatbot($conversation['chatbot_id']);
                            $chatbot_name = $chatbot ? $chatbot['name'] : __('Unknown Chatbot', 'a1ai-chatbot');
                            
                            // Get messages for this conversation
                            $messages = $data_manager->get_messages($conversation['id']);
                            $message_count = count($messages);
                            $tokens_used = 0;
                            foreach ($messages as $message) {
                                $tokens_used += intval($message['tokens_used']);
                            }
                            
                            // Format user info
                            $user_info = $conversation['user_id'] > 0 
                                ? get_user_by('id', $conversation['user_id'])->display_name 
                                : __('Guest', 'a1ai-chatbot');
                            ?>
                            <tr class="a1ai-conversation-row" data-conversation-id="<?php echo esc_attr($conversation['id']); ?>">
                                <td><?php echo esc_html($chatbot_name); ?></td>
                                <td><?php echo esc_html($user_info); ?></td>
                                <td>
                                    <code><?php echo esc_html(substr($conversation['session_id'], 0, 20) . '...'); ?></code>
                                </td>
                                <td><?php echo esc_html($message_count); ?></td>
                                <td><?php echo esc_html(number_format_i18n($tokens_used)); ?></td>
                                <td><?php echo esc_html(date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($conversation['created_at']))); ?></td>
                                <td>
                                    <button type="button" class="button button-small a1ai-view-conversation" data-conversation-id="<?php echo esc_attr($conversation['id']); ?>">
                                        <?php echo esc_html__('View', 'a1ai-chatbot'); ?>
                                    </button>
                                    <button type="button" class="button button-small a1ai-delete-conversation" data-conversation-id="<?php echo esc_attr($conversation['id']); ?>">
                                        <?php echo esc_html__('Delete', 'a1ai-chatbot'); ?>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
        
        <div class="a1ai-conversation-preview" id="a1ai-conversation-preview">
            <div class="a1ai-preview-header">
                <h3><?php echo esc_html__('Conversation Preview', 'a1ai-chatbot'); ?></h3>
                <button type="button" class="a1ai-preview-close">&times;</button>
            </div>
            <div class="a1ai-preview-body">
                <div class="a1ai-preview-placeholder">
                    <p><?php echo esc_html__('Select a conversation to view its details.', 'a1ai-chatbot'); ?></p>
                </div>
                <div class="a1ai-preview-content" style="display: none;">
                    <div class="a1ai-preview-info">
                        <div class="a1ai-preview-meta">
                            <span class="a1ai-preview-chatbot"></span>
                            <span class="a1ai-preview-user"></span>
                            <span class="a1ai-preview-time"></span>
                        </div>
                    </div>
                    <div class="a1ai-preview-messages"></div>
                </div>
            </div>
        </div>
    </div> 
