<?php
/**
 * Admin chatbots list template
 *
 * @link       https://a1aidigital.com
 * @since      1.0.0
 *
 * @package    A1AI
 * @subpackage A1AI/admin/partials
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Load plugin functions if not already loaded
if (!function_exists('is_plugin_active')) {
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');
}

// Get all chatbots
$chatbots = $data_manager->get_chatbots();
?>

<div class="a1ai-wrap">
    <div class="a1ai-header">
        <h1><?php echo esc_html__('Manage Chatbots', 'a1ai-chatbot'); ?></h1>
        <div class="a1ai-header-actions">
            <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=a1ai-chatbots&action=add'), 'a1ai_chatbot_action')); ?>" class="button button-primary">
                <?php echo esc_html__('Add New Chatbot', 'a1ai-chatbot'); ?>
            </a>
        </div>
    </div>

    <div class="a1ai-notices"></div>
    
    <?php
    // Check if API key is set
    $api_key = get_option('a1ai_openai_api_key', '');
    if (empty($api_key)) {
        ?>
        <div class="a1ai-notice a1ai-notice-warning">
            <p>
                <?php echo esc_html__('The OpenAI API key is not set. Please configure it in the', 'a1ai-chatbot'); ?>
                <a href="<?php echo esc_url(admin_url('admin.php?page=a1ai-settings')); ?>"><?php echo esc_html__('Settings', 'a1ai-chatbot'); ?></a>
                <?php echo esc_html__('page before creating chatbots.', 'a1ai-chatbot'); ?>
            </p>
        </div>
        <?php
    }
    ?>

    <div class="a1ai-container">


        <div class="a1ai-tabs-nav">
            <a href="#tab-chatbots" class="active"><?php echo esc_html__('Manage Chatbots', 'a1ai-chatbot'); ?></a>
            <a href="#tab-conversations"><?php echo esc_html__('Conversations', 'a1ai-chatbot'); ?></a>
            <a href="#tab-adjustments"><?php echo esc_html__('Adjustments', 'a1ai-chatbot'); ?></a>
            <?php if (class_exists('A1AI_Upgrade_Helper') && A1AI_Upgrade_Helper::is_upgrade_active()): ?>
            <a href="#tab-contact-forms"><?php echo esc_html__('Contact Forms', 'a1ai-chatbot'); ?></a>
            <a href="#tab-reviews"><?php echo esc_html__('Reviews', 'a1ai-chatbot'); ?></a>
            <?php else: ?>
            <a href="#tab-upgrade" style="background: linear-gradient(45deg, #0073aa, #005177); color: white; font-weight: bold;">🚀 <?php echo esc_html__('Upgrade', 'a1ai-chatbot'); ?></a>
            <?php endif; ?>
        </div>
        
        <div class="a1ai-tab-content active" id="tab-chatbots">
            <h2><?php echo esc_html__('Manage Chatbots', 'a1ai-chatbot'); ?></h2>
            <?php if (empty($chatbots)) : ?>
                <div class="a1ai-empty-state">
                    <p><?php echo esc_html__('You don\'t have any chatbots yet.', 'a1ai-chatbot'); ?></p>
                    <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=a1ai-chatbots&action=add'), 'a1ai_chatbot_action')); ?>" class="button button-primary">
                        <?php echo esc_html__('Create Your First Chatbot', 'a1ai-chatbot'); ?>
                    </a>
                </div>
            <?php else : ?>
                <div class="a1ai-chatbots-list">
                    <?php foreach ($chatbots as $chatbot) : 
                        // Get the shortcode for this chatbot
                        $shortcode = '[a1ai_chatbot id="' . $chatbot['id'] . '"]';
                        
                        // Check if this is the global chatbot
                        $global_chatbot_id = get_option('a1ai_global_chatbot_id', 0);
                        $is_global = ($global_chatbot_id == $chatbot['id']);
                        ?>
                        <div class="a1ai-chatbot-item">
                            <div class="a1ai-chatbot-info">
                                <div class="a1ai-chatbot-name">
                                    <?php echo esc_html($chatbot['name']); ?>
                                    <?php if ($is_global) : ?>
                                        <span class="a1ai-tag"><?php echo esc_html__('Global', 'a1ai-chatbot'); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="a1ai-chatbot-shortcode">
                                    <code><?php echo esc_html($shortcode); ?></code>
                                    <button type="button" class="button button-small a1ai-copy-shortcode" data-shortcode="<?php echo esc_attr($shortcode); ?>">
                                        <?php echo esc_html__('Copy', 'a1ai-chatbot'); ?>
                                    </button>
                                </div>
                            </div>
                            <div class="a1ai-chatbot-actions">
                                <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=a1ai-chatbots&action=edit&id=' . $chatbot['id']), 'a1ai_chatbot_action')); ?>" class="button">
                                    <?php echo esc_html__('Edit', 'a1ai-chatbot'); ?>
                                </a>
                                <button type="button" class="button a1ai-delete-chatbot" data-id="<?php echo esc_attr($chatbot['id']); ?>">
                                    <?php echo esc_html__('Delete', 'a1ai-chatbot'); ?>
                                </button>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="a1ai-tab-content" id="tab-conversations" style="display: none;">
            <?php include plugin_dir_path(__FILE__) . 'a1ai-admin-conversations.php'; ?>
        </div>
        
        <div class="a1ai-tab-content" id="tab-adjustments" style="display: none;">
            <?php include plugin_dir_path(__FILE__) . 'a1ai-admin-adjustments.php'; ?>
        </div>

        <?php if (class_exists('A1AI_Upgrade_Helper') && A1AI_Upgrade_Helper::is_upgrade_active()): ?>
        <div class="a1ai-tab-content" id="tab-contact-forms" style="display: none;">
            <?php include plugin_dir_path(__FILE__) . 'a1ai-admin-contact-forms.php'; ?>
        </div>

        <div class="a1ai-tab-content" id="tab-reviews" style="display: none;">
            <?php include plugin_dir_path(__FILE__) . 'a1ai-admin-reviews.php'; ?>
        </div>
        <?php else: ?>
        <div class="a1ai-tab-content" id="tab-upgrade" style="display: none;">
            <?php include plugin_dir_path(__FILE__) . 'a1ai-admin-upgrade.php'; ?>
        </div>
        <?php endif; ?>
    </div>
</div>


