/**
 * A1AI Admin Chatbots JavaScript
 *
 * @package    A1AI
 * @subpackage A1AI/admin/js
 */

(function($) {
    'use strict';

    // Wait for document ready to ensure all elements are loaded
    $(document).ready(function() {
        // Tab switching functionality
        $('.a1ai-tabs-nav a').off('click').on('click', function(e) {
            e.preventDefault();

            const $this = $(this);
            const targetTab = $this.attr('href');

            // Update active tab
            $('.a1ai-tabs-nav a').removeClass('active');
            $this.addClass('active');

            // Show target tab content
            $('.a1ai-tab-content').removeClass('active').hide();
            $(targetTab).addClass('active').show();

            // Update URL hash
            if (history.pushState) {
                history.pushState(null, null, targetTab);
            } else {
                location.hash = targetTab;
            }
        });

        // Check for URL parameters first (like ?active_tab=reviews)
        const urlParams = new URLSearchParams(window.location.search);
        const activeTab = urlParams.get('active_tab');

        if (activeTab) {
            const targetHash = '#tab-' + activeTab;
            const $tabLink = $('.a1ai-tabs-nav a[href="' + targetHash + '"]');
            if ($tabLink.length) {
                window.location.hash = targetHash;
                $tabLink.click();
                return; // Exit early since we found a parameter
            }
        }

        // Check for hash in URL on page load
        const hash = window.location.hash;
        if (hash) {
            const $tabLink = $('.a1ai-tabs-nav a[href="' + hash + '"]');
            if ($tabLink.length) {
                $tabLink.click();
            }
        } else {
            // If no hash, ensure first tab is active and visible
            const $firstTab = $('.a1ai-tabs-nav a').first();
            const firstTabTarget = $firstTab.attr('href');

            // Make sure first tab nav is active
            $('.a1ai-tabs-nav a').removeClass('active');
            $firstTab.addClass('active');

            // Make sure first tab content is visible
            $('.a1ai-tab-content').removeClass('active').hide();
            $(firstTabTarget).addClass('active').show();
        }

        // Copy shortcode functionality
        $('.a1ai-copy-shortcode').on('click', function() {
            const shortcode = $(this).data('shortcode');
            const tempInput = $('<input>');
            $('body').append(tempInput);
            tempInput.val(shortcode).select();
            document.execCommand('copy');
            tempInput.remove();

            const $button = $(this);
            const originalText = $button.text();
            $button.text(typeof a1aichAdmin !== 'undefined' ? a1aichAdmin.copiedText : 'Copied!');

            setTimeout(function() {
                $button.text(originalText);
            }, 2000);
        });
    }); // Close document.ready

})(jQuery); 