/**
 * A1AI Admin Chatbot Edit JavaScript
 *
 * @package    A1AI
 * @subpackage A1AI/admin/js
 */

(function($) {
    'use strict';

    // Copy shortcode functionality
    $('.a1ai-copy-shortcode').on('click', function() {
        const shortcode = $(this).data('shortcode');
        const tempInput = $('<input>');
        $('body').append(tempInput);
        tempInput.val(shortcode).select();
        document.execCommand('copy');
        tempInput.remove();
        
        const $button = $(this);
        const originalText = $button.text();
        $button.text(a1aiAdminVars.copiedText);
        
        setTimeout(function() {
            $button.text(originalText);
        }, 2000);
    });
    
    // GDPR consent toggle functionality
    $('#gdpr_enabled').on('change', function() {
        const isChecked = $(this).is(':checked');
        $('#gdpr-consent-text-field').toggle(isChecked);
        
        // If checked and the text area is empty, add default text
        if (isChecked && $('#gdpr_consent_text').val().trim() === '') {
            $('#gdpr_consent_text').val(a1aiAdminVars.defaultGdprText);
        }
    });

})(jQuery); 