/**
 * A1AI Admin Adjustments JavaScript
 *
 * @package    A1AI
 * @subpackage A1AI/admin/js
 */

(function($) {
    'use strict';

    // Edit adjustment functionality
    $('.a1ai-edit-adjustment').on('click', function() {
        const adjustmentId = $(this).data('adjustment-id');
        const userInput = $(this).data('user-input');
        const aiOutput = $(this).data('ai-output');
        const uiMatch = $(this).data('ui-match');
        const aiMatch = $(this).data('ai-match');
        
        // Populate the edit form
        $('#edit_adjustment_id').val(adjustmentId);
        $('#edit_user_input').val(userInput);
        $('#edit_ai_output').val(aiOutput);
        
        // Show the modal
        $('#a1ai-edit-modal').show();
    });
    
    // Close modal when clicking the X
    $('.a1ai-modal-close').on('click', function() {
        $('#a1ai-edit-modal').hide();
    });
    
    // Close modal when clicking Cancel
    $('.a1ai-modal-cancel').on('click', function() {
        $('#a1ai-edit-modal').hide();
    });
    
    // Close modal when clicking outside of it
    $(window).on('click', function(event) {
        const modal = $('#a1ai-edit-modal');
        if (event.target === modal[0]) {
            modal.hide();
        }
    });
    
    // Handle form submission
    $('#a1ai-edit-form').on('submit', function(e) {
        // Form will submit normally - no need to prevent default
        // The PHP will handle the submission and show success/error messages
    });

})(jQuery); 