<?php
/**
 * A1AI Chatbot
 *
 * @package     A1AI
 * @author      A1AI
 * @copyright   2023 A1AI
 * @license     GPL-2.0+
 *
 * @wordpress-plugin
 * Plugin Name: A1AI Chatbot
 * Plugin URI:  https://a1aidigital.com/ai-wordpress-plugin/
 * Description: AI-powered chatbot solution for WordPress
 * Version:     1.5.6
 * Author:      A1AI Digital
 * Author URI:  https://a1aidigital.com/ai-wordpress-plugin/
 * Text Domain: a1ai-chatbot
 * Domain Path: /languages
 * License:     GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Plugin version
define('A1AI_VERSION', '1.5.6');
define('A1AI_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('A1AI_PLUGIN_URL', plugin_dir_url(__FILE__));
define('A1AI_PLUGIN_BASENAME', plugin_basename(__FILE__));

/**
 * The code that runs during plugin activation.
 */
function a1ai_activate() {
    require_once A1AI_PLUGIN_DIR . 'includes/class-a1ai-activator.php';
    A1AI_Activator::activate();
}
register_activation_hook(__FILE__, 'a1ai_activate');

/**
 * The code that runs during plugin deactivation.
 */
function a1ai_deactivate() {
    require_once A1AI_PLUGIN_DIR . 'includes/class-a1ai-deactivator.php';
    A1AI_Deactivator::deactivate();
}
register_deactivation_hook(__FILE__, 'a1ai_deactivate');

/**
 * Map old text domain to new one for backward compatibility
 * 
 * This function loads translations from the new text domain when the old one is requested
 */
function a1ai_text_domain_compatibility() {
    // Register a filter to handle text domain mapping
    add_filter('override_load_textdomain', 'a1ai_override_textdomain', 10, 3);
}

/**
 * Override the text domain loading to map 'a1ai' to 'a1ai-chatbot'
 *
 * @param bool   $override Whether to override the .mo file loading
 * @param string $domain   Text domain
 * @param string $mofile   Path to the MO file
 * @return bool Whether to override the .mo file loading
 */
function a1ai_override_textdomain($override, $domain, $mofile) {
    // If the old domain is requested, load the new domain's translations instead
    if ($domain === 'a1ai') {
        // Get the path to the new domain's MO file
        $new_mofile = str_replace("/{$domain}/", '/a1ai-chatbot/', $mofile);
        $new_mofile = str_replace("{$domain}.mo", 'a1ai-chatbot.mo', $new_mofile);
        
        // Load the new domain's translations
        load_textdomain('a1ai', $new_mofile);
        
        // Return true to indicate we've handled the loading
        return true;
    }
    
    return $override;
}
add_action('init', 'a1ai_text_domain_compatibility');

/**
 * Set up plugin for translation.
 * 
 * Note: For WordPress.org plugins, no manual loading is needed.
 * WordPress.org automatically handles translation loading since 4.6.
 */
function a1ai_setup_translation() {
    // This function exists for backward compatibility
    // and to support translations when not on WordPress.org
    
    // No code needed here for WordPress.org plugins
    // The translations are loaded automatically based on the plugin header
}
add_action('plugins_loaded', 'a1ai_setup_translation');

/**
 * The core plugin class.
 */
require_once A1AI_PLUGIN_DIR . 'includes/class-a1ai.php';

/**
 * Begins execution of the plugin.
 *
 * @since    1.0.0
 */
function a1ai_run() {
    $plugin = new A1AI();
    $plugin->run();
}
a1ai_run(); 
