jQuery(document).ready(function($) {
    
    // ==========================================================================
    // Tab Navigation
    // ==========================================================================
    
    $('.nav-tab').on('click', function(e) {
        e.preventDefault();
        
        var tabId = $(this).data('tab');
        
        // Update tab active state
        $('.nav-tab').removeClass('nav-tab-active');
        $(this).addClass('nav-tab-active');
        
        // Show/hide tab content
        $('.digital99-tab-content').removeClass('active').hide();
        $('#tab-' + tabId).addClass('active').show();
        
        // Update URL hash without scrolling
        if (history.pushState) {
            history.pushState(null, null, '#' + tabId);
        }
    });
    
    // Handle initial hash on page load
    function handleInitialHash() {
        var hash = window.location.hash.replace('#', '');
        if (hash && $('[data-tab="' + hash + '"]').length) {
            $('[data-tab="' + hash + '"]').trigger('click');
        }
    }
    handleInitialHash();
    
    // ==========================================================================
    // Copy link functionality
    // ==========================================================================
    
    $('#copy-link-btn').on('click', function(e) {
        e.preventDefault();
        var linkText = $('#onboarding-link-input').val();
        var $successMsg = $('#copy-success');
        
        // Modern clipboard API with fallback
        if (navigator.clipboard && window.isSecureContext) {
            navigator.clipboard.writeText(linkText).then(function() {
                $successMsg.fadeIn(200).delay(2500).fadeOut(400);
            }).catch(function(err) {
                // Fallback
                fallbackCopy(linkText);
                $successMsg.fadeIn(200).delay(2500).fadeOut(400);
            });
        } else {
            // Fallback for older browsers or non-HTTPS
            fallbackCopy(linkText);
            $successMsg.fadeIn(200).delay(2500).fadeOut(400);
        }
    });
    
    function fallbackCopy(text) {
        var textArea = document.createElement('textarea');
        textArea.value = text;
        textArea.style.position = 'fixed';
        textArea.style.left = '-999999px';
        textArea.style.top = '-999999px';
        document.body.appendChild(textArea);
        textArea.focus();
        textArea.select();
        try {
            document.execCommand('copy');
        } catch (err) {
            console.error('Copy failed:', err);
        }
        document.body.removeChild(textArea);
    }
    
    // ==========================================================================
    // Token verification
    // ==========================================================================
    
    $('#verify-token-btn').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $status = $('#token-status');
        var token = $('#store-token').val().trim();
        
        if (!token) {
            $status.html('<span class="error-message">נא להזין טוקן</span>');
            return;
        }
        
        $button.prop('disabled', true).html('מאמת... <span class="digital99-loading"></span>');
        $status.html('');
        
        $.ajax({
            url: digital99_ajax.ajax_url,
            method: 'POST',
            data: {
                action: 'digital99_verify_token',
                nonce: digital99_ajax.nonce,
                token: token
            },
            success: function(response) {
                if (response.success) {
                    var status = parseInt(response.data.status);
                    if (status === 1) {
                        $status.html('<span class="success-message">הטוקן אומת בהצלחה! מסנכרן מוצרים...</span>');
                        // Auto-trigger product sync, then reload
                        $.ajax({
                            url: digital99_ajax.ajax_url,
                            method: 'POST',
                            data: {
                                action: 'digital99_sync_products',
                                nonce: digital99_ajax.nonce
                            },
                            complete: function() {
                                $status.html('<span class="success-message">✅ סנכרון הושלם! הדף ירענן...</span>');
                                setTimeout(function() {
                                    location.reload();
                                }, 1500);
                            }
                        });
                    } else {
                        $status.html('<span class="success-message">הטוקן אומת בהצלחה! הדף ירענן...</span>');
                        setTimeout(function() {
                            location.reload();
                        }, 1500);
                    }
                } else {
                    $status.html('<span class="error-message">' + (response.data.message || 'הטוקן שהזנת אינו תקין') + '</span>');
                    $button.prop('disabled', false).text('אמת טוקן והתחבר');
                }
            },
            error: function() {
                $status.html('<span class="error-message">שגיאה בתקשורת עם השרת</span>');
                $button.prop('disabled', false).text('אמת טוקן והתחבר');
            }
        });
    });
    
    // ==========================================================================
    // Check onboarding status
    // ==========================================================================
    
    $('#check-onboarding-btn').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $status = $('#onboarding-status');
        var token = digital99_ajax.stored_token || '';
        
        $button.prop('disabled', true).html('בודק... <span class="digital99-loading"></span>');
        $status.html('');
        
        $.ajax({
            url: digital99_ajax.ajax_url,
            method: 'POST',
            data: {
                action: 'digital99_verify_token',
                nonce: digital99_ajax.nonce,
                token: token || $('#store-token').val()
            },
            success: function(response) {
                if (response.success && response.data && parseInt(response.data.status) === 1) {
                    $status.html('<span class="success-message">🎉 מעולה! החיבור הושלם! מסנכרן מוצרים...</span>');
                    // Auto-trigger product sync, then reload
                    $.ajax({
                        url: digital99_ajax.ajax_url,
                        method: 'POST',
                        data: {
                            action: 'digital99_sync_products',
                            nonce: digital99_ajax.nonce
                        },
                        complete: function() {
                            $status.html('<span class="success-message">✅ סנכרון הושלם! הדף ירענן...</span>');
                            setTimeout(function() {
                                location.reload();
                            }, 1500);
                        }
                    });
                } else {
                    $status.html('<span class="error-message">נראה שתהליך החיבור ב-Meta עדיין לא הושלם. נסה שוב לאחר שתסיים את התהליך.</span>');
                    $button.prop('disabled', false).text('בדוק סטטוס חיבור');
                }
            },
            error: function(xhr, status, error) {
                $status.html('<span class="error-message">שגיאה בתקשורת עם השרת</span>');
                $button.prop('disabled', false).text('בדוק סטטוס חיבור');
            }
        });
    });
    
    // ==========================================================================
    // Disconnect
    // ==========================================================================
    $('#disconnect-btn').on('click', function(e) {
        e.preventDefault();
        
        if (!confirm('האם אתה בטוח שברצונך להתנתק? תצטרך להזין טוקן חדש כדי להתחבר מחדש.')) {
            return;
        }
        
        var $button = $(this);
        $button.prop('disabled', true).text('מתנתק...');
        
        $.ajax({
            url: digital99_ajax.ajax_url,
            method: 'POST',
            data: {
                action: 'digital99_disconnect',
                nonce: digital99_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    alert('החיבור נותק בהצלחה');
                    location.reload();
                } else {
                    alert('שגיאה בניתוק החיבור');
                    $button.prop('disabled', false).text('התנתק');
                }
            },
            error: function() {
                alert('שגיאה בתקשורת עם השרת');
                $button.prop('disabled', false).text('התנתק');
            }
        });
    });

    // ==========================================================================
    // Sync products
    // ==========================================================================
    
    function syncAllProducts(showAlert) {
        var $button = $('#sync-products-btn');
        var $status = $('#sync-products-status');
        
        if ($button.length === 0) {
            return;
        }
        
        $button.prop('disabled', true).html('מסנכרן... <span class="digital99-loading"></span>');
        $status.html('<span class="info-message">⏳ מסנכרן מוצרים לשרת, אנא המתן...</span>');
        
        $.ajax({
            url: digital99_ajax.ajax_url,
            method: 'POST',
            data: {
                action: 'digital99_sync_products',
                nonce: digital99_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    var count = response.data.synced_count || 0;
                    var total = response.data.total_products || 0;
                    if (total === 0) {
                        $status.html('<span class="info-message">ℹ️ אין מוצרים מפורסמים בחנות לסנכרון</span>');
                    } else if (count === 0) {
                        $status.html('<span class="error-message">⚠️ נמצאו ' + total + ' מוצרים אך לא הצליח לסנכרן</span>');
                    } else {
                        $status.html('<span class="success-message">✅ סונכרנו ' + count + ' מתוך ' + total + ' מוצרים בהצלחה!</span>');
                    }
                } else {
                    $status.html('<span class="error-message">שגיאה: ' + (response.data.message || 'שגיאה לא ידועה') + '</span>');
                }
            },
            error: function(xhr, status, error) {
                $status.html('<span class="error-message">שגיאה בתקשורת עם השרת</span>');
            },
            complete: function() {
                $button.prop('disabled', false).html('📦 סנכרן כל המוצרים');
            }
        });
    }
    
    $('#sync-products-btn').on('click', function(e) {
        e.preventDefault();
        syncAllProducts(true);
    });

    // ==========================================================================
    // Load messages from server
    // ==========================================================================
    
    function loadMessagesFromServer() {
        if ($('#digital99-messages-form').length === 0 && $('#shipping-settings-form').length === 0) {
            return;
        }
        
        $('#messages-loading, #shipping-loading').show();
        $('#digital99-messages-form, #shipping-settings-form').hide();
        
        $.ajax({
            url: digital99_ajax.ajax_url,
            method: 'POST',
            data: {
                action: 'digital99_load_messages',
                nonce: digital99_ajax.nonce
            },
            success: function(response) {
                $('#messages-loading, #shipping-loading').hide();
                $('#digital99-messages-form, #shipping-settings-form').show();
                
                if (response.success) {
                    // All message field names
                    var messageFields = [
                        'message_1_welcome',
                        'message_2_cart_sent',
                        'message_3_cart_not_sent',
                        'message_4_summary_and_payment',
                        'message_5_payment_completed',
                        'message_6_no_payment',
                        'message_7_pickup',
                        'message_8_shipping',
                        'message_9_shipping_price'
                    ];
                    
                    messageFields.forEach(function(field) {
                        var $field = $('#' + field);
                        var value = response.data[field] || '';
                        $field.val(value);
                    });
                    
                    // Set shipping method dropdown
                    if (response.data.shipping_method) {
                        $('#shipping_method').val(response.data.shipping_method);
                    }
                } 
            },
            error: function(xhr, status, error) {
                $('#messages-loading, #shipping-loading').hide();
                $('#digital99-messages-form, #shipping-settings-form').show();
            }
        });
    }

    loadMessagesFromServer();

    // ==========================================================================
    // Save messages
    // ==========================================================================

    $('#save-messages-btn').on('click', function(e) {
        e.preventDefault();

        var $button = $(this);
        var $status = $('#save-messages-status');
        
        // Required fields (message_7_pickup is optional)
        var requiredFields = [
            'message_1_welcome',
            'message_2_cart_sent',
            'message_3_cart_not_sent',
            'message_4_summary_and_payment',
            'message_5_payment_completed',
            'message_6_no_payment',
            'message_8_shipping',
            'message_9_shipping_price'
        ];
        
        // Validate all required fields are not empty
        var emptyFields = [];
        
        requiredFields.forEach(function(fieldId) {
            var $field = $('#' + fieldId);
            var value = $field.val() ? $field.val().trim() : '';
            if (!value) {
                emptyFields.push(fieldId);
                $field.addClass('field-error');
            } else {
                $field.removeClass('field-error');
            }
        });
        
        if (emptyFields.length > 0) {
            $status.html('<span class="error-message">כל השדות המסומנים חייבים להיות ממולאים</span>');
            // Switch to messages tab if missing fields are there
            if ($('#tab-messages').find('.field-error').length > 0) {
                $('[data-tab="messages"]').trigger('click');
            }
            return;
        }

        var formData = {
            action: 'digital99_save_messages',
            nonce: digital99_ajax.nonce
        };

        // All message field names
        var messageFields = [
            'message_1_welcome',
            'message_2_cart_sent',
            'message_3_cart_not_sent',
            'message_4_summary_and_payment',
            'message_5_payment_completed',
            'message_6_no_payment',
            'message_7_pickup',
            'message_8_shipping',
            'message_9_shipping_price'
        ];
        
        messageFields.forEach(function(field) {
            formData[field] = $('#' + field).val() || '';
        });

        formData['shipping_method'] = $('#shipping_method').val();

        $button.prop('disabled', true).html('שומר... <span class="digital99-loading"></span>');
        $status.html('');

        $.ajax({
            url: digital99_ajax.ajax_url,
            method: 'POST',
            data: formData,
            success: function(response) {
                if (response.success) {
                    $status.html('<span class="success-message">✅ ' + response.data.message + '</span>');
                } else {
                    $status.html('<span class="error-message">שגיאה: ' + response.data.message + '</span>');
                }
            },
            error: function(xhr, status, error) {
                $status.html('<span class="error-message">שגיאה בתקשורת עם השרת</span>');
            },
            complete: function() {
                $button.prop('disabled', false).html('💾 שמור שינויים');
            }
        });
    });
});
