<?php
/**
 * Plugin Name: 99digital Store Bridge
 * Description: Connect WooCommerce with WhatsApp for seamless order management and product synchronization.
 * Version: 2.0.1
 * Author: 99digital
 * Text Domain: 99digital
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

define('DIGITAL99_PLUGIN_PATH', plugin_dir_path(__FILE__));

require_once DIGITAL99_PLUGIN_PATH . 'includes/class-admin-settings.php';
require_once DIGITAL99_PLUGIN_PATH . 'includes/class-api-handler.php';
require_once DIGITAL99_PLUGIN_PATH . 'includes/meta-order-endpoint.php';

register_uninstall_hook(__FILE__, array('Digital99_API_Handler', 'on_uninstall'));

function digital99_init() {
    if (!class_exists('WooCommerce')) {
        add_action('admin_notices', 'digital99_woocommerce_missing_notice');
        return;
    }
    
    new Digital99_Admin_Settings();
    new Digital99_API_Handler();
}
add_action('plugins_loaded', 'digital99_init');

function digital99_woocommerce_missing_notice() {
    ?>
    <div class="notice notice-error">
        <p><strong>99דיגיטל:</strong> התוסף דורש WooCommerce להיות מותקן ופעיל.</p>
    </div>
    <?php
}
