<?php
/* *********************************************************************
 * This Original Work is copyright of 51 Degrees Mobile Experts Limited.
 * Copyright 2026 51 Degrees Mobile Experts Limited, Davidson House,
 * Forbury Square, Reading, Berkshire, United Kingdom RG1 3EU.
 *
 * This Original Work is licensed under the European Union Public Licence
 * (EUPL) v.1.2 and is subject to its terms as set out below.
 *
 * If a copy of the EUPL was not distributed with this file, You can obtain
 * one at https://opensource.org/licenses/EUPL-1.2.
 *
 * The 'Compatible Licences' set out in the Appendix to the EUPL (as may be
 * amended by the European Commission) shall be deemed incompatible for
 * the purposes of the Work and the provisions of the compatibility
 * clause in Article 5 of the EUPL shall not apply.
 *
 * If using the Work as, or as part of, a network application, by
 * including the attribution notice(s) required under Article 5 of the EUPL
 * in the end user terms of the application under an appropriate heading,
 * such notice(s) shall fulfill the requirements of that article.
 * ********************************************************************* */

declare(strict_types=1);

namespace fiftyone\pipeline\engines;

/**
 * AspectData class extension that stores content as an array
 * Similar to ElementDataDictionary in the Pipeline core library.
 */
class AspectDataDictionary extends AspectData
{
    /**
     * @var array<string, mixed>
     */
    private array $contents;

    /**
     * Constructor for element data dictionary.
     *
     * @param array<string, mixed> $contents Dictionary contents
     */
    public function __construct(Engine $flowElement, array $contents)
    {
        $this->contents = $contents;

        parent::__construct($flowElement);
    }

    /**
     * Get the values contained in the aspectData instance as a dictionary
     * of keys and values.
     *
     * @return array<string, mixed>
     */
    public function asDictionary(): array
    {
        return $this->contents;
    }

    /**
     * Internal getter for contents.
     *
     * @return mixed
     */
    public function getInternal(string $key)
    {
        return $this->contents[$key] ?? null;
    }
}
