<?php
/*
 * Plugin Name:       5 ways...
 * Plugin URI:        https://5ways.pl
 * Description:       Plugin for configuring 5 Ways chat widget, case management, and survey generator scripts.
 * Version:           1.1.4
 * Tested up to: 6.8
 * Requires at least: 6.4
 * Requires PHP:      7.2
 * Author:            Dominik Modrzejewski
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       five-ways-widget
 * Domain Path:       /languages
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

// Ładowanie tłumaczeń
function five_ways_load_textdomain() {
    load_plugin_textdomain( 'five-ways-widget', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'five_ways_load_textdomain' );

// Dodajemy menu ustawień dla administratora
function five_ways_menu()
{
	add_menu_page(
		__('5 ways... Ustawienia widgetu czatu, obsługi spraw, ankiet', 'five-ways-widget'),
		__('5 ways... Ustawienia widgetu czatu, obsługi spraw, ankiet', 'five-ways-widget'),
		'manage_options',
		'five_ways_settings',
		'five_ways_settings_page'
	);
}

add_action('admin_menu', 'five_ways_menu');

// Dodajemy stronę ustawień
function five_ways_settings_page()
{
	?>
    <div class="wrap">
        <h1><?php esc_html_e('5 ways... Ustawienia widgetu czatu, obsługi spraw, ankiet', 'five-ways-widget'); ?></h1>
        <form method="post" action="options.php">
			<?php settings_fields('five_ways_settings_group'); ?>
			<?php do_settings_sections('five_ways_settings'); ?>
			<?php settings_errors('five_ways_settings_group'); ?>
            <div id="widget_ids_container">
				<?php
				// Wczytujemy istniejące wartości widgetId
				$options = get_option('five_ways_settings');
				if (!empty($options['widget_ids'])) {
					foreach ($options['widget_ids'] as $widget_id) {
						echo '<div class="remove" style="margin: 10px 0"><input type="text" name="five_ways_settings[widget_ids][]" value="' . esc_attr($widget_id) . '" data-widget-id="' . esc_attr($widget_id) . '"/><a href="#" class="remove_widget_id" style="margin-left: 20px">' . esc_html__('Usuń widget', 'five-ways-widget') . '</a></div>';

					}
				}
				?>
            </div>
            <button type="button" id="add_widget_id" style=""><?php esc_html_e('Dodaj widget', 'five-ways-widget'); ?>
            </button>
            <br/><br/>
			<?php submit_button(__('Zapisz zmiany', 'five-ways-widget'), 'primary', 'submit', true, null); ?>
        </form>
    </div>
	<?php
}

function five_ways_admin_scripts()
{
	?>
    <script>
        jQuery(document).ready(function ($) {
            $('#add_widget_id').click(function () {
                $('#widget_ids_container').append('<div style="margin: 10px 0"><input type="text" name="five_ways_settings[widget_ids][]" value=""/><a href="#" class="remove_widget_id" style="margin-left: 20px"><?php echo esc_js(__('Usuń widget', 'five-ways-widget')); ?></a></div>');
            });

            $(document).on('click', '.remove_widget_id', function () {
                var widget_id = $(this).siblings('input[type="text"]').data('widget-id');
                $(this).parent().remove(); // Usuwamy pole z widoku
                $(this).closest('input').remove();
                $('script[widgetId="' + widget_id + '"]').remove(); // Usuwamy skrypt z footer'a
            });
        });
    </script>
	<?php
}

add_action('admin_footer', 'five_ways_admin_scripts');


// Dodajemy pola do formularza ustawień
function five_ways_settings_init()
{
	register_setting(
		'five_ways_settings_group',
		'five_ways_settings',
		'five_ways_settings_validate'
	);

	add_settings_section(
		'five_ways_settings_section',
		__('Ustawienia Skryptu', 'five-ways-widget'),
		'five_ways_settings_section_callback',
		'five_ways_settings'
	);

	add_settings_field(
		'five_ways_selected_pages',
		__('Wybierz stronę', 'five-ways-widget'),
		'five_ways_selected_pages_callback',
		'five_ways_settings',
		'five_ways_settings_section'
	);

	add_settings_field(
		'five_ways_widget_ids',
		__('Wartości widgetId', 'five-ways-widget'),
		'five_ways_widget_ids_callback',
		'five_ways_settings',
		'five_ways_settings_section'
	);
}

add_action('admin_init', 'five_ways_settings_init');

// Wyświetlamy pole wprowadzania wartości widgetId

function five_ways_widget_ids_callback()
{
	$options = get_option('five_ways_settings');
	$widget_ids = isset($options['widget_ids']) ? $options['widget_ids'] : array();

}

// Dodajemy sekcję do formularza ustawień
function five_ways_settings_section_callback()
{

}

// Wybór konkretnej strony
function five_ways_selected_pages_callback()
{
	$options = get_option('five_ways_settings');
	$selected_pages = isset($options['selected_pages']) ? $options['selected_pages'] : array();
	$pages = get_pages();
	$home_page_id = get_option('page_on_front');

	if (!wp_script_is('select2', 'enqueued')) {
		wp_enqueue_script('select2', plugin_dir_url(__FILE__) . 'select2/select2.min.js', array('jquery'), '4.1.0-rc.0', true);
	}

	echo '<script>
        jQuery(document).ready(function() {
            var selectedPages = ' . esc_js(wp_json_encode($selected_pages)) . ';
            var pagesList = ' . esc_js(wp_json_encode($pages)) . ';
 
            jQuery("#five_ways_selected_pages").select2({
               inimumResultsForSearch: -1, // Trigger search after 1 characters
                placeholder: "' . esc_js(__('Wyszukaj stronę', 'five-ways-widget')) . '",
                allowClear: false, // Enable clearing all selections,
             
                templateResult: function(data) {
                    if (data.id === "") { // placeholder for search input
                        return data.text;
                    }
 
                    const selected = selectedPages.includes(data.id) ? "selected" : "";
                    return jQuery("<option " + selected + "></option>").text(data.text);
                }
            });
        });
    </script>';

	echo '<div class="five-ways-page-select">';
	echo '<select id="five_ways_selected_pages" class="js-example-basic-single" name="five_ways_settings[selected_pages][]"  data-live-search="true">';

	// Dodajemy opcję dla strony głównej do listy rozwijanej
	echo '<option value="' . esc_attr($home_page_id) . '" ' . (in_array($home_page_id, $selected_pages) ? 'selected' : '') . '>' . esc_html__('Strona główna', 'five-ways-widget') . '</option>';

	foreach ($pages as $page) {
		$checked = in_array($page->ID, $selected_pages) ? 'selected' : '';
		echo '<option value="' . esc_attr($page->ID) . '" ' . checked( true, $checked, false ) . '>' . esc_html($page->post_title) . '</option>';
	}

	echo '</select>';
	echo '</div>';

	foreach ($pages as $page) {
		if (in_array($page->ID, $selected_pages)) {
			$checked = 'checked';
			echo '<p><label><input type="checkbox" name="five_ways_settings[selected_pages][]" value="' . esc_attr($page->ID) . '" ' . esc_attr($checked) . '> ' . esc_html($page->post_title) . '</label></p>';
		}
	}
	// Dodajemy opcję dla strony głównej, jeśli jest zaznaczona

	if (in_array($home_page_id, $selected_pages)) {
		$home_page_checked = 'checked';
		echo '<p><input type="checkbox" name="five_ways_settings[selected_pages][]" value="' . esc_attr($home_page_id) . '" ' . esc_attr($home_page_checked) . '> ' . esc_html__('Strona główna', 'five-ways-widget') . '</p>';
	}

}


// Funkcja do walidacji wprowadzonych danych
function five_ways_settings_validate($input)
{
	if (empty($input)) {
		add_settings_error('five_ways_settings_group', 'five_ways_settings_error', esc_html__('Sprawdź wprowadzone dane.', 'five-ways-widget'), 'error');
		return false;
	}

	$newInput = array();

	if (isset($input['selected_pages']) && is_array($input['selected_pages'])) {
		$newInput['selected_pages'] = array_map('intval', $input['selected_pages']);
	}

	if (isset($input['widget_ids']) && is_array($input['widget_ids'])) {
		$newInput['widget_ids'] = array_filter($input['widget_ids'], function ($widget_id) {
			return !empty(trim($widget_id));
		});
	}

	return $newInput;
}

// Wstrzykujemy skrypt do stopki strony
function five_ways_enqueue_script()
{

	$options = get_option('five_ways_settings');
	$selected_pages = isset($options['selected_pages']) ? $options['selected_pages'] : array();
	$widget_ids = isset($options['widget_ids']) ? $options['widget_ids'] : array();

	// Sprawdzamy czy jesteśmy na stronie głównej
	$is_home = (is_home() || is_front_page()) && in_array(get_option('page_on_front'), $selected_pages);

	// Sprawdzamy czy jesteśmy na wybranej stronie (podstronie)
	$is_selected_page = is_page() && in_array(get_the_ID(), $selected_pages);


	if (($is_home || $is_selected_page) && !empty($widget_ids)) {
		foreach ($widget_ids as $widget_id) {
			if (!empty($widget_id)) {
				wp_enqueue_script('five-ways-widget-' . esc_attr($widget_id), 'https://chat.5ways.pl/assets/scripts/widget.js', array(), null, true);
				wp_add_inline_script('five-ways-widget-' . esc_attr($widget_id), 'window.widgetId = "' . esc_js($widget_id) . '";', 'before');
			}
		}
	}

}

add_action('wp_enqueue_scripts', 'five_ways_enqueue_script');

// Dodawanie stylów CSS
function five_ways_enqueue_styles()
{
	wp_enqueue_style('five_ways_admin_style', plugin_dir_url(__FILE__) . 'style.css');
	wp_enqueue_style('select2', plugin_dir_url(__FILE__) . 'select2/select2.min.css');
}

add_action('admin_enqueue_scripts', 'five_ways_enqueue_styles');

// Funkcja obsługująca shortcode
function five_ways_script_shortcode($atts)
{

	// Domyślne atrybuty
	$atts = shortcode_atts(array('widget_id' => ''), $atts);

	// Sprawdź czy widget_id został podany
	if (empty($atts['widget_id'])) {
		return '<p>' . esc_html__('Brak identyfikatora widgetu.', 'five-ways-widget') . '</p>';
	}

	$widget_id = esc_attr($atts['widget_id']);

	// Enqueue skryptu tylko przy użyciu shortcode
	wp_enqueue_script('five-ways-widget-shortcode-' . $widget_id, 'https://chat.5ways.pl/assets/scripts/widget.js', array(), null, true);
	wp_add_inline_script('five-ways-widget-shortcode-' . $widget_id, 'window.widgetId = "' . esc_js($widget_id) . '";', 'before');

	return '';
}

add_shortcode('five_ways_widget', 'five_ways_script_shortcode');


// Sprawdzamy czy administrator ustawił widgety i na jakiej stronie ma być wyświetlany
function five_ways_widget_notice()
{
	$options = get_option('five_ways_settings');
	$widget_ids = isset($options['widget_ids']) ? $options['widget_ids'] : array();

	if (empty($widget_ids)) {
		echo '<div class="notice notice-warning is-dismissible">';
		echo '<p>' . sprintf(
			esc_html__('Nie ustawiono identyfikatora widgetu dla wtyczki 5 ways. %sSkonfiguruj ustawienia%s.', 'five-ways-widget'),
			'<a href="' . esc_url(admin_url('admin.php?page=five_ways_settings')) . '">',
			'</a>'
		) . '</p>';
		echo '</div>';
	}
}

add_action('admin_notices', 'five_ways_widget_notice');

?>

